/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/source/bin/RCS/tcfsrmkey.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:13:00 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <kdes.h>
#include <tcfs.h>
#include <tcfslib.h>
#include <tcfserrors.h>
#include <grp.h>

extern char *optarg;
extern int optind;
char *usage=
"usage: tcfsrmkey [-f fliesystem-label][-g group][-p mount-point]\n";

void main(int argc, char *argv[])
{
	char *fs;
	uid_t uid;
	gid_t gid;
	int es;
	char x;
	char fslabel[255],fspath[255];
	int havempname=FALSE, havefsname=FALSE, isgroupkey=FALSE;
	int havefs=FALSE;
	int havename=FALSE, havefspath=FALSE;

	while((x=getopt(argc,argv,"f:p:g:"))!=EOF)
	{
	 switch(x)
	 	{
		case 'p':
			 havempname=TRUE;
			 strncpy(fspath,optarg,strlen(optarg));
			 break;
		case 'f':
			 havefsname=TRUE;
			 strncpy(fslabel,optarg,strlen(optarg));
			 break;
		case 'g':
			 isgroupkey=TRUE;
			 gid=atoi(optarg);
			 if(!gid && optarg[0]!=0)
			 {
			  struct group *grp;
			  grp=(struct group *)getgrnam(optarg);
			  if(!grp)
				tcfs_error(ER_CUSTOM,"Nonexistant group\n");
			  gid=grp->gr_gid;
			 }
			 break;
		default: 
			 tcfs_error(ER_CUSTOM,usage);
			 exit(ER_UNKOPT);
		}
	}
	if(argc-optind)
		tcfs_error(ER_UNKOPT,NULL);

	if(havefsname && havempname)
		{
		 tcfs_error(ER_CUSTOM,usage);
		 exit(1);
		}
			 
	if(havefsname)
		{
		 es=tcfs_getfspath(fslabel,fspath);
		 havename=TRUE;
		}

	if(havefspath)
		 havename=TRUE;

	if(!havename)
		 es=tcfs_getfspath("default",fspath);

	if(!es)
		{
		 tcfs_error(ER_CUSTOM,"fs-label not found!\n");
		 exit(1);
		}
		
	uid=getuid();

	if(isgroupkey)
		{
		 es=tcfs_group_disable(fspath,uid,gid);
		 if(es==-1)
			tcfs_error(ER_CUSTOM,"problems updating filesystem");
		 exit(0);
		}


				

		es=tcfs_user_disable(fspath,uid);

		if(es==-1)
			tcfs_error(ER_CUSTOM,"problems updating filesystem");
}
