/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/tcfs-utils_0.1/bin/RCS/tcfsrmgroup.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:13:00 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <tcfslib.h>
#include <grp.h>

#include "tcfserrors.h"

char *usage="Usage: %s [OPTION]...
Remove a TCFS group from the TCFS group database.

  -g <group>   Specifies the TCFS group to be removed
  -h           Shows this help
  -v           Makes the output a little more verbose\n";

int main (int argn, char *argv[])
{
	int index, val;
	gid_t gid;
	int have_gid=FALSE, be_verbose=FALSE;

	/*
	 * Going to check the arguments
	 */
	while ((val=getopt(argn, argv, "hg:v"))!=EOF)
		switch (val)
		{
			case 'g':
				gid=(gid_t)atoi(optarg);
				if (!gid && optarg[0]!='0') /* group name given */
				{
					struct group *group_id;

					group_id=getgrnam(optarg);
					if (!group_id)
						tcfs_error (ER_CUSTOM, "Nonexistent group.");
					gid=group_id->gr_gid;
				}

				have_gid=TRUE;
				break;
			case 'h':
				show_usage (usage, argv[0]);
				exit (OK);
			case 'v':
				be_verbose=TRUE;
				break;
			default:
				fprintf (stderr, "Try %s --help for more informations.\n", argv[0]);
				exit (ER_UNKOPT);
		}

	if (argn-optind)
		tcfs_error (ER_UNKOPT, NULL);

	if (!have_gid)
	{
		char *buff=NULL;

		buff=(char*)calloc(2048, sizeof(char));
		if (!buff)
			tcfs_error (ER_MEM, NULL);

		printf ("Group id of the TCFS group to remove from the database: ");
		fgets (buff,2048,stdin);
		buff[strlen(buff)-1]='\0';
		gid=(gid_t)atoi(buff);

		if (!gid && optarg[0]!='0') /* group name given */
		{
			struct group *group_id;

			group_id=getgrnam(optarg);
			if (!group_id)
				tcfs_error (ER_CUSTOM, "Nonexistent group.");
			gid=group_id->gr_gid;
		}

		if (gid<=0)
			tcfs_error (ER_CUSTOM, "A positive ID please!");

		free (buff);
	}

	if (!tcfs_rmgroup (gid))
		tcfs_error (ER_CUSTOM, "Wrong ID or an error as occurred.\n");
}
