/*
 *	Transparent Cryptographic File System (TCFS) for NetBSD 
 *	Author and mantainer: 	Luigi Catuogno [luicat@tcfs.unisa.it]
 *	
 *	references:		http://tcfs.dia.unisa.it
 *				tcfs-bsd@tcfs.unisa.it
 */

/*
 *	Base utility set v0.1
 *
 *	  $Source: /home/luicat/source/bin/RCS/tcfsflag.c,v $
 *	   $State: Exp $
 *	$Revision: 1.1 $
 *	  $Author: luicat $
 *	    $Date: 1999/10/28 10:13:00 $
 *
 */

static const char *RCSid="$id: $";

/* RCS_HEADER_ENDS_HERE */



#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <ctype.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <sys/wait.h>
#include <kdes.h>
#include <tcfs.h>

tcfs_flags tcfs_getflags(int);
tcfs_flags tcfs_setflags(int,tcfs_flags);

void main(int argc, char *argv[])
{
	int fd;
	tcfs_flags i;

	if(argc < 3)
		{
		 fprintf (stderr,"tcfsflags {r,x,g} file\n\n");
		 exit(1);
		}

	fd=open(argv[2],O_RDONLY);
	if(!fd)
		{
		 fprintf(stderr,"open failed\n");
		 exit(1);
		}
	i=tcfs_getflags(fd);
	if(i.flag==TCFS_EFLGS)
	{
	 fprintf(stderr,"getflags error\n");
	 close(fd);
	 exit(1);
	}

	switch(*argv[1])
	{
		case 'r':
			printf("%s x:%d g:%d\n",argv[2],
				FI_CFLAG(&i),FI_GSHAR(&i));
			exit(0);
		case 'x':
			i.bf.mb=~i.bf.mb;
			break;
		case 'g':
			i.bf.gshar=~i.bf.gshar;
			break;
	}					

	i=tcfs_setflags(fd,i);
	if(i.flag==TCFS_EFLGS)
		{
		 fprintf(stderr,"setflags error\n");
		 exit(1);
		}
	close(fd);
	exit(0);
}
	
