/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPOptionsGrafPort.h,v 1.9 1999/04/04 11:13:45 wprice Exp $
____________________________________________________________________________*/

#pragma once

// Public includes:
#include "CComboError.h"
#include "pgpPubTypes.h"

// Private includes:
#include "CPGPUIGrafPortView.h"

class CPGPOptionView;
class CPGPOptionsListView;
class CPGPOptionsDialogOptions;

class CPGPOptionsGrafPort : public CPGPUIGrafPortView
{
public:

	enum { class_ID = 'OLGP' };
	
						CPGPOptionsGrafPort(LStream *inStream);
	virtual				~CPGPOptionsGrafPort();

	virtual void		UpdatePort();
	virtual void		FinishCreateSelf(void);
	
	PGPError			SetOptions(PGPContextRef context,
								CPGPOptionsDialogOptions *options);
	
protected:

	virtual void		DrawSelf(void);

private:

	CPGPOptionsListView	*mOptionsListView;
	
	const CPGPOptionsDialogOptions	*mOptions;
	
	void				AppendOptionView(CPGPOptionView *theView,
								SInt32 viewOffset);
	void				BuildOptionsView(CPGPOptionView	*owningView,
								PGPOptionListRef optionList,
								SInt32 viewOffset);
};

