/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CPGPDecrPassphraseGrafPort.h,v 1.11 1999/03/10 02:36:50 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPKeyPassphraseGrafPort.h"

class CPGPRecipientTable;

class CPGPDecryptionPassphraseGrafPortView : 
			public CPGPKeySetPassphraseGrafPortView
{
public:

	enum
	{
		class_ID = 'DPGP',
		
		kRecipientUserIDTablePaneID	= 'tUsr'
	};

						CPGPDecryptionPassphraseGrafPortView(LStream *inStream);
	virtual				~CPGPDecryptionPassphraseGrafPortView();

	virtual void		ListenToMessage(MessageT inMessage, void *ioParam);
	PGPError			SetOptions(PGPContextRef context,
							CPGPDecryptionPassphraseDialogOptions *options);
							
protected:

	CPGPRecipientTable	*mRecipientTable;

	virtual void		FinishCreateSelf(void);
	virtual PGPKeyRef	FindKeyForPassphrase(PGPKeySetRef keySet,
								const char *passphrase);
	virtual PGPKeyRef	GetPassphraseKey(void);
	
private:

	CPGPDecryptionPassphraseDialogOptions		*mOptions;
	
	PGPError			AddKeySetToRecipientsTable(PGPKeySetRef keySet);
	PGPError			BuildRecipientsTable(void);
};
