/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CString.h,v 1.6 1999/04/02 00:49:17 jason Exp $
____________________________________________________________________________*/

#pragma once 


/*	Usage:
		MinStorage:	CString will expand or contract its storage as the string grows or
					shrinks but will never reduce it below this size.
		Secure:		Controls whether the class uses secure memory or not. NOTE: Remember
					not to assign any data before turning this flag on if you want security.
		operator[]:	The indexing operator is 0 based.
*/
class CString {
	friend class CStringAdaptor;
	friend class CStringFromSTR;
	friend class CStringFromSTRx;
	friend class CStringFromInt;
	
public:
	enum {	kStandardMinStorage = 255 };
	
					CString(const char * inString = "",
						PGPSize inMinStorage = kStandardMinStorage);
					CString(ConstStringPtr inString,
						PGPSize inMinStorage = kStandardMinStorage);
					CString(const CStringAdaptor & inStringAdapter,
						PGPSize inMinStorage = kStandardMinStorage);
					CString(PGPByte * inChars, PGPSize inLength,
						PGPSize inMinStorage = kStandardMinStorage);
					CString(const CString & inRHS);
					~CString();
	
	void			SetMinStorage(PGPSize inMinStorage);
	PGPSize			GetMinStorage() const { return mMinStorage; }
	
//	void			SetSecure(PGPBoolean inSecure);
	PGPBoolean		GetSecure() const { return mSecure; }
	
	void			SetLength(PGPSize inStringLength);
	PGPSize			GetLength() const;
	PGPByte			GetPascalLength() const;
	
					operator ConstStringPtr();
					operator StringPtr();
					operator const char *();
					operator char *();
	
	CString &		operator=(const CString & inRHS);
	
	void			Assign(const char * inString);
	void			Assign(ConstStringPtr inString);
	void			Assign(const CStringAdaptor & inStringAdaptor);
	
private:
	PGPByte *		mStorage;
	PGPSize			mMinStorage;
	PGPSize			mStringLength;
	PGPBoolean		mSecure;
	PGPBoolean		mIsCString;
	PGPBoolean		mIsPascalString;
	PGPBoolean		mStringLengthGood;
	
	inline void		Init();
	inline void		Set(const PGPByte * inData, PGPSize inLength);
	inline PGPSize	GetMaxStringLength() const;
	inline void		ReallocateStorage();
};



class CStringAdaptor {
	friend CString;
	
protected:
	virtual void	Set(CString * inCString) const = 0;
};



class CStringFromSTR : public CStringAdaptor {
public:
					CStringFromSTR(PGPInt16 inResID)
						: mResID(inResID) { }

private:
	PGPInt16		mResID;
	
	virtual void	Set(CString * inCString) const;
};



class CStringFromSTRx : public CStringAdaptor {
public:
					CStringFromSTRx(PGPInt16 inResID, PGPInt16 inIndex)
						: mResID(inResID), mIndex(inIndex) { }

private:
	PGPInt16		mResID;
	PGPInt16		mIndex;
	
	virtual void	Set(CString * inCString) const;
};



class CStringFromInt : public CStringAdaptor {
public:
					CStringFromInt(PGPInt32 inInt32)
						: mInt32(inInt32) { }

private:
	PGPInt32		mInt32;
	
	virtual void	Set(CString * inCString) const;
};