/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: pgpNavServices.h,v 1.4 1999/03/10 02:53:41 heller Exp $
____________________________________________________________________________*/

#pragma once 


#include <Navigation.h>

typedef struct PGPNavReply
{
	NavReplyRecord	rr;
} PGPNavReply;

	OSErr
PGPNavGetFileOrFolder(
	Boolean					chooseFolder,
	Str255					message,
	OSType					defaultCreator,
	PGPUInt16				numTypes,
	OSType *				allowTypes,
	NavEventProcPtr			updateFunc,
	FSSpec *				choice );

	OSErr
PGPNavPutFile(
	Str255					message,
	Str255					defaultName,
	OSType					fileType,
	OSType					fileCreator,
	PGPNavReply *			navReply,	// pass NULL to disable translation
	NavMenuItemSpecHandle	addItem,	// pass NULL for no extra items
	PGPBoolean *			itemSelected,
	NavEventProcPtr			updateFunc,
	FSSpec *				choice );

	OSErr
PGPNavFinishSave(
	PGPNavReply	*			navReply );

