/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc. and it's affiliated companies
	All rights reserved.

	$Id: PGPsdaMacFileFormat.h,v 1.6 1999/03/07 07:28:44 heller Exp $
____________________________________________________________________________*/

#pragma once

#define kPGPsdaCreator			'pGpS'
#define kPGPseaCreator			'pGpA'
#define kPGPsdaArchiveMagic		kPGPsdaCreator

#define kPGPsdaCompressionBlockSize		(64L * 1024L)

enum
{
	kPGPsdaHeaderType_Invalid		= 0,
	kPGPsdaHeaderType_File			= 1,
	kPGPsdaHeaderType_BeginFolder	= 2,
	kPGPsdaHeaderType_EndFolder		= 3,
	kPGPsdaHeaderType_EndArchive	= 4
};

typedef PGPUInt8	PGPsdaHeaderType;

#pragma options align=mac68k

typedef struct PGPsdaFileHeader
{
	Str31		name;
	OSType		fileType;
	OSType		fileCreator;
	Point		windowIconPos;
	PGPUInt16	finderFlags;
	PGPUInt16	windowID;
	PGPUInt32	dataForkLength;
	PGPUInt32	resForkLength;
	PGPUInt32	creationDate;
	PGPUInt32	modificationDate;
	PGPInt8		scriptCode;
	PGPInt8		extendedFinderFlags;
	PGPBoolean	locked;
	PGPInt8		reserved;
	
} PGPsdaFileHeader;

typedef struct PGPsdaBeginFolderHeader
{
	Str31		name;
	PGPUInt32	creationDate;
	DInfo		folderInfo;
	PGPInt8		scriptCode;
	PGPInt8		extendedFlags;

} PGPsdaBeginFolderHeader;

typedef struct PGPsdaEndFolderHeader
{
	PGPUInt32	modificationDate;
	Point		windowScroll;
} PGPsdaEndFolderHeader;

typedef struct PGPsdaCompBlockHeader
{
	OSType		magic;
	PGPUInt32	blockSize;
	PGPBoolean	notCompressed;
	PGPBoolean	pad1;
	PGPBoolean	pad2;
	PGPBoolean	pad3;
	
} PGPsdaCompBlockHeader;

typedef struct PGPsdaArchiveCheckBytes
{
	PGPByte	bytes[16];
	
} PGPsdaArchiveCheckBytes;

typedef struct PGPsdaArchiveHeader
{
	OSType		magic;
	PGPUInt32	fileSize;
	
	PGPByte		passphraseSalt[8];
	PGPUInt32	hashReps;
	PGPUInt32	compressedBlockSize;
	PGPByte		encryptedDataHash[20];	/* SHA-1 hash */
	PGPBoolean	isEncryptedArchive;
	PGPBoolean	padByte;
	
	PGPsdaArchiveCheckBytes	checkBytes;
	
} PGPsdaArchiveHeader;

#pragma options align=reset
