/*____________________________________________________________________________
	Copyright (C) 1997-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.

	$Id: CPGPtoolsTextTask.h,v 1.14 1999/03/10 02:38:32 heller Exp $
____________________________________________________________________________*/

#pragma once

#include "CPGPtoolsBufferTask.h"

class CPGPtoolsTextTask : public CPGPtoolsBufferTask
{
public:
						CPGPtoolsTextTask(PGPtoolsOperation operation);
	virtual				~CPGPtoolsTextTask(void);
	virtual CToolsError	DecryptVerify(PGPContextRef	context,
								PGPtlsContextRef tlsContext,
								CDecodeParams *state);
	virtual	CToolsError	EncryptSign(PGPContextRef context,
								PGPtlsContextRef tlsContext,
								CEncodeParams *state);
	virtual	void		SetSourceFileName(ConstStringPtr name);

protected:

	virtual	void		GetDecryptPassphrasePromptString(StringPtr prompt);
	virtual	void		GetTaskItemName(StringPtr name);
	virtual	CToolsError	ProcessOutputData(void);
	
private:

	Str32				mSourceFileName;
	
	virtual	void		BuildErrorMessage(CToolsError err,
							short errorStrIndex, StringPtr msg);
};