/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CFYEODialog.h,v 1.4 1999/04/10 11:12:49 jason Exp $
____________________________________________________________________________*/

#pragma once 

#include <UGWorld.h>

#include "CPGPModalGrafPortView.h"



class CTempestView: public LView {
public:
	enum					{ class_ID = 'TmpV' };

							CTempestView(LStream * inStream);
	virtual					~CTempestView();

	void					SetString(const char * inString) { mString = inString; Refresh(); }
	void					UseTempest(bool inUseTempest)
								{ mResizeImage = true; mUseTempest = inUseTempest; }

protected:
	bool					mUseTempest;
	bool					mResizeImage;
	const char *			mString;
	LGWorld *				mTempestFont;
	
	virtual void			DrawSelf();

	UInt16					GetNumCharsToDraw(const char * inCurrChar,
								UInt16 inHowManyAlreadyDrawn, UInt16 inFrameWidth,
								UInt16 inCharWidth);
};


class CFYEODialog :	public CPGPModalGrafPortView {
public:
	enum					{ class_ID = 'FYEO' };

							CFYEODialog(LStream * inStream);
	virtual					~CFYEODialog();

	virtual void			FinishCreateSelf();
	virtual void			ListenToMessage(MessageT inMessage, void * ioParam);

	PGPError				SetInfo(PGPContextRef inContext, const char * inString,
								PGPBoolean inFYEO);
								
	PGPBoolean				GetCopyToClipboard() { return mCopyToClipboard; }
	
protected:
	PGPContextRef			mContext;
	CTempestView *			mTempestView;
	PGPBoolean				mCopyToClipboard;
};
