/*
	File:		OldOTConfigLib.h

	Contains:	Old interface to the OT TCP/IP and AppleTalk configurators.

	Written by:	Quinn

	Copyright:	Copyright (C) 1998 by Apple Computer, Inc., all rights reserved.

				You may incorporate this Apple sample source code into your program(s) without
				restriction. This Apple sample source code has been provided "AS IS" and the
				responsibility for its operation is yours. You are not permitted to redistribute
				this Apple sample source code as "Apple sample source code" after having made
				changes. If you're going to re-distribute the source, we require that you make
				it clear in the source that the code was descended from Apple sample source
				code, but that you've made changes.

	Change History (most recent first):

         <3>     2/19/99    wprice  MODIFIED BY NETWORK ASSOCIATES
         <2>     5/11/98    Quinn   Fix headers.
         <1>     5/11/98    Quinn   First checked in.
*/

#ifndef __OLDOTCONFIGLIB__
#define __OLDOTCONFIGLIB__

/* Consequences of changing configuration */

enum Consequence
{
	kNoAnswer		= -1,	/* Couldn't get in touch with the protocol (probably not loaded => benign)	*/
	kBenignChange	=  0,	/* Change won't disturb aything												*/
	kKillsServices	=  1,	/* Change will interrupt connections currently established					*/
	kMustReboot		=  2	/* Change requires a reboot to take effect									*/
};

#ifdef __cplusplus
extern "C" {
#endif

extern SInt32 TCPCheckChangeConfigurationConsequences(SInt16 resFileRefNum, SInt16 configResID);
	/* Check with TCP/IP what would be the consequences of changing the current 					*/
	/* config to the specified one.																	*/

extern OSErr TCPChangeConfiguration(SInt16 resFileRefNum, SInt16 configResID);
	/* Makes the TCP/IP configuration the active configuration and notifies							*/
	/* the protocol of this change.																	*/
	/* The protocol will react as announced by TCPCheckChangeConfigurationConsequences				*/

extern SInt32 ATCheckChangeConfigurationConsequences(SInt16 ref, SInt16 config);
	/* Check with AppleTalk what would be the consequences of changing the current 					*/
	/* config to the specified one.																	*/

extern OSErr ATChangeConfiguration(SInt16 ref, SInt16 config);
	/* Makes the AppleTalk configuration the active configuration and notifies						*/
	/* the protocol of this change.																	*/
	/* The protocol will react as announced by TCPCheckChangeConfigurationConsequences				*/

#ifdef __cplusplus
}
#endif

#endif
