/*____________________________________________________________________________
	Copyright (C) 1999 Network Associates, Inc.
	All rights reserved.

	$Id: CAdvancedPanel.cp,v 1.17 1999/05/21 10:14:15 wprice Exp $
____________________________________________________________________________*/
#include <LPushButton.h>
#include <LPopupButton.h>
#include <LCheckBox.h>
#include <LCheckBoxGroupBox.h>
#include <PP_Messages.h>
#include <LWindow.h>

#include "pgpClientLib.h"
#include "pgpBuildFlags.h"
#include "WarningAlert.h"
#include "pflPrefTypes.h"
#include "pgpMem.h"
#include "MacStrings.h"
#include "CPGPStDialogHandler.h"

#include "CString.h"
#include "CIconPane.h"
#include "CPGPnet.h"
#include "CAdvancedPanel.h"


namespace
{
	const PaneIDT	checkbox_CAST				=	'xCAS';
	const PaneIDT	checkbox_3DES				=	'x3DE';
	const PaneIDT	checkbox_DES56				=	'xDE5';
	const PaneIDT	checkbox_NoCipher			=	'xCNo';
	const PaneIDT	checkbox_SHA				=	'xSHA';
	const PaneIDT	checkbox_MD5				=	'xMD5';
	const PaneIDT	checkbox_NoHash				=	'xHNo';
	const PaneIDT	checkbox_DH768				=	'x768';
	const PaneIDT	checkbox_DH1024				=	'x102';
	const PaneIDT	checkbox_DH1536				=	'x153';
	const PaneIDT	checkbox_LZS				=	'xLZS';
	const PaneIDT	checkbox_Deflate			=	'xDef';
	const PaneIDT	popup_IPSECGroup			=	'pGrp';
	
	const PaneIDT	button_NewIKE				=	'bNeI';
	const PaneIDT	button_NewIPSEC				=	'bNeS';
	const PaneIDT	button_Edit					=	'bEdi';
	const PaneIDT	button_Remove				=	'bRmv';
	const PaneIDT	button_MoveUp				=	'bMUp';
	const PaneIDT	button_MoveDown				=	'bMDn';
	const PaneIDT	button_Defaults				=	'bDef';

	const PaneIDT	table_IKE					=	'tIKE';
	const PaneIDT	table_IPSEC					=	'tIPS';
	
	const ResIDT	ppob_IKEProposal			=	3001;
	const ResIDT	ppob_IPSECProposal			=	3002;

	enum
	{
		STRx_AdvancedPanel			=	1009,
		kDES56WarningID				=	1,
		kNoneID						=	2,
		kInvalidIPSECID				=	3,
		
		STRx_IKEAuth				=	1010,
		STRx_IKECipher				=	1011,
		STRx_IKEGroup				=	1012,
		STRx_Compression			=	1013,
		STRx_Encryption				=	1007,
		STRx_Authentication			=	1008
	};
}

CAdvancedPanel::CAdvancedPanel(
	LStream *	inStream)
	: CPanel(inStream)
{
}

CAdvancedPanel::~CAdvancedPanel()
{
}

	void
CAdvancedPanel::FinishCreateSelf()
{
	// Listen to buttons
	((LCheckBox *) FindPaneByID(checkbox_DES56))->AddListener(this);

	((LPushButton *) FindPaneByID(button_NewIKE))->AddListener(this);
	((LPushButton *) FindPaneByID(button_NewIPSEC))->AddListener(this);
	(mEditButton = (LPushButton *) FindPaneByID(button_Edit))->
		AddListener(this);
	(mRemoveButton = (LPushButton *) FindPaneByID(button_Remove))->
		AddListener(this);
	(mMoveUpButton = (LPushButton *) FindPaneByID(button_MoveUp))->
		AddListener(this);
	(mMoveDownButton = (LPushButton *) FindPaneByID(button_MoveDown))->
		AddListener(this);
	((LPushButton *) FindPaneByID(button_Defaults))->AddListener(this);
	
	mSelectedTable	= NULL;
	mChange			= FALSE;
	
	mIKETable = (CIKETable *) FindPaneByID( table_IKE );
	mIKETable->SetPanel( this );
	mIKETable->AddListener( this );
	mIPSECTable = (CIPSECTable *) FindPaneByID( table_IPSEC );
	mIPSECTable->SetPanel( this );
	mIPSECTable->AddListener( this );
	Load(NULL);
}

	void
CAdvancedPanel::IKEProposalDialog(
	PGPUInt32				propIndex )
{
	CPGPnetStDialogHandler	ikeDialog( ppob_IKEProposal, CPGPnet::GetApplication() );
	LWindow					*theDialog;
	MessageT				message;
	PGPUInt16				value;
	LPopupButton *			cipherPop;

	const PaneIDT			kAuthPopupID	= 'pAut';
	const PaneIDT			kHashPopupID	= 'pHas';
	const PaneIDT			kCipherPopupID	= 'pCip';
	const PaneIDT			kCipher2PopupID	= 'pCi2';
	const PaneIDT			kGroupPopupID	= 'pGrp';
	
	theDialog = ikeDialog.GetDialog();
	cipherPop = (LPopupButton *)theDialog->FindPaneByID( kCipherPopupID );
#if PGPNET_ALLOW_DES56
	cipherPop->Hide();
	cipherPop = (LPopupButton *)theDialog->FindPaneByID( kCipher2PopupID );
	cipherPop->Show();
#endif
	if( propIndex != MAX_PGPUInt32 )
	{
		( (LPopupButton *)theDialog->FindPaneByID( kAuthPopupID ) )->
			SetValue( mIKETable->mIKEProps[ propIndex ].authMethod );
		( (LPopupButton *)theDialog->FindPaneByID( kHashPopupID ) )->
			SetValue( mIKETable->mIKEProps[ propIndex ].hash );
#if PGPNET_ALLOW_DES56
		switch( mIKETable->mIKEProps[ propIndex ].cipher )
		{
			case kPGPike_SC_DES_CBC:
				value = 1;
				break;
			case kPGPike_SC_3DES_CBC:
				value = 2;
				break;
			default:
			case kPGPike_SC_CAST_CBC:
				value = 3;
				break;
		}
#else
		switch( mIKETable->mIKEProps[ propIndex ].cipher )
		{
			case kPGPike_SC_3DES_CBC:
				value = 1;
				break;
			default:
			case kPGPike_SC_CAST_CBC:
				value = 2;
				break;
		}
#endif
		cipherPop->SetValue( value );
		switch( mIKETable->mIKEProps[ propIndex ].groupID )
		{
			/*case kPGPike_GR_MODPOne:
				value = 1;
				break;*/
			case kPGPike_GR_MODPTwo:
				value = 1;
				break;
			case kPGPike_GR_MODPFive:
				value = 2;
				break;
		}
		( (LPopupButton *)theDialog->FindPaneByID( kGroupPopupID ) )->
			SetValue( value );
	}
	
	theDialog->Show();
	do
	{
		message = ikeDialog.DoDialog();
	} while( ( message != msg_OK ) && ( message != msg_Cancel ) );
	if( message == msg_OK )
	{
		if( propIndex == MAX_PGPUInt32 )
		{
			if( IsntPGPError( PGPReallocData( CPGPnet::GetMemMgr(),
				&mIKETable->mIKEProps,
				( mIKETable->mNumProps + 1 )
				* sizeof( PGPNetPrefIKEProposalEntry), 0 )))
			{
				propIndex = mIKETable->mNumProps++;
				mIKETable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
						sizeof( PGPUInt32 ), FALSE, TRUE );
			}
			else
				return;
		}
		mIKETable->mIKEProps[ propIndex ].authMethod = (PGPikeAuthMethod)
			( (LPopupButton *)theDialog->
			FindPaneByID( kAuthPopupID ) )->GetValue();
		mIKETable->mIKEProps[ propIndex ].hash = (PGPikeHash)
			( (LPopupButton *)theDialog->
			FindPaneByID( kHashPopupID ) )->GetValue();
			
		value = cipherPop->GetValue();
#if PGPNET_ALLOW_DES56
		switch( value )
		{
			case 2:
				value = kPGPike_SC_3DES_CBC;
				break;
			case 3:
				value = kPGPike_SC_CAST_CBC;
				break;
		}
#else
		switch( value )
		{
			case 1:
				value = kPGPike_SC_3DES_CBC;
				break;
			default:
			case 2:
				value = kPGPike_SC_CAST_CBC;
				break;
		}
#endif
		mIKETable->mIKEProps[ propIndex ].cipher = (PGPikeCipher)value;
		switch( value = ( (LPopupButton *)theDialog->
					FindPaneByID( kGroupPopupID ) )->GetValue() )
		{
			default:
			case 1:
				value = kPGPike_GR_MODPTwo;
				break;
			case 2:
				value = kPGPike_GR_MODPFive;
				break;
		}
		mIKETable->mIKEProps[ propIndex ].groupID = (PGPikeGroupID)value;
		
		STableCell	lCell, rCell;
		
		lCell.row = rCell.row = propIndex + 1;
		lCell.col = 1;
		rCell.col = 4;
		mIKETable->RefreshCellRange( lCell, rCell );
	}
}

	void
CAdvancedPanel::IPSECProposalDialog(
	PGPUInt32			propIndex )
{
	CPGPnetStDialogHandler	ipsecDialog( ppob_IPSECProposal, CPGPnet::GetApplication() );
	LWindow					*theDialog;
	MessageT				message;
	PGPUInt16				value;
	LPopupButton *			cipherPop;
	
	const PaneIDT			kAHGroupCheckBoxID		= 'xAH ';
	const PaneIDT			kESPGroupCheckBoxID		= 'xESP';
	const PaneIDT			kIPPCPGroupCheckBoxID	= 'xIPC';
	const PaneIDT			kAHHashPopupID			= 'pAHH';
	const PaneIDT			kESPHashPopupID			= 'pESH';
	const PaneIDT			kESPCipherPopupID		= 'pESC';
	const PaneIDT			kESPCipher2PopupID		= 'pEC2';
	const PaneIDT			kIPCAlgPopupID			= 'pIPC';
	
	theDialog = ipsecDialog.GetDialog();
	cipherPop = (LPopupButton *)theDialog->FindPaneByID( kESPCipherPopupID );
#if PGPNET_ALLOW_DES56
	cipherPop->Hide();
	cipherPop = (LPopupButton *)theDialog->FindPaneByID( kESPCipher2PopupID );
	cipherPop->Show();
#endif
	if( propIndex != MAX_PGPUInt32 )
	{
		((LCheckBoxGroupBox *)theDialog->FindPaneByID( kAHGroupCheckBoxID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].useAH );
		((LCheckBoxGroupBox *)theDialog->FindPaneByID( kESPGroupCheckBoxID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].useESP );
		((LCheckBoxGroupBox *)theDialog->FindPaneByID( kIPPCPGroupCheckBoxID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].useIPCOMP );
		((LPopupButton *)theDialog->FindPaneByID( kAHHashPopupID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].ahHash );
		((LPopupButton *)theDialog->FindPaneByID( kESPHashPopupID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].espHash + 1 );
		switch( mIPSECTable->mIPSECProps[propIndex].espCipher )
		{
#if PGPNET_ALLOW_DES56
			case kPGPike_ET_DES_IV64:
			case kPGPike_ET_DES:
				value = 2;
				break;
			case kPGPike_ET_3DES:
				value = 3;
				break;
			default:
			case kPGPike_ET_CAST:
				value = 4;
				break;
			case kPGPike_ET_NULL:
				value = 1;
				break;
#else
			case kPGPike_ET_3DES:
				value = 2;
				break;
			default:
			case kPGPike_ET_CAST:
				value = 3;
				break;
			case kPGPike_ET_NULL:
				value = 1;
				break;
#endif
		}
		cipherPop->SetValue( value );
		((LPopupButton *)theDialog->FindPaneByID( kIPCAlgPopupID ))->
			SetValue( mIPSECTable->mIPSECProps[propIndex].ipcomp - 1 );
	}
	
	theDialog->Show();
tryAgain:
	do
	{
		message = ipsecDialog.DoDialog();
	} while( ( message != msg_OK ) && ( message != msg_Cancel ) );
	if( message == msg_OK )
	{
		if( propIndex == MAX_PGPUInt32 )
		{
			if( IsntPGPError( PGPReallocData( CPGPnet::GetMemMgr(),
				&mIPSECTable->mIPSECProps,
				( mIPSECTable->mNumProps + 1 )
				* sizeof( PGPNetPrefIPSECProposalEntry ), 0 )))
			{
				propIndex = mIPSECTable->mNumProps++;
				mIPSECTable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
						sizeof( PGPUInt32 ), FALSE, TRUE );
			}
			else
				return;
		}
		mIPSECTable->mIPSECProps[propIndex].useAH =
			((LCheckBoxGroupBox *)theDialog->
			FindPaneByID( kAHGroupCheckBoxID ))->GetValue();
		mIPSECTable->mIPSECProps[propIndex].useESP =
			((LCheckBoxGroupBox *)theDialog->
			FindPaneByID( kESPGroupCheckBoxID ))->GetValue();
		
		if( !mIPSECTable->mIPSECProps[propIndex].useAH &&
			!mIPSECTable->mIPSECProps[propIndex].useESP )
		{
			WarningAlert(	kWAStopAlertType,
								kWAOKStyle,
								STRx_AdvancedPanel,
								kInvalidIPSECID );
			goto tryAgain;
		}
		
		mIPSECTable->mIPSECProps[propIndex].useIPCOMP =
			((LCheckBoxGroupBox *)theDialog->
			FindPaneByID( kIPPCPGroupCheckBoxID ))->GetValue();
		mIPSECTable->mIPSECProps[propIndex].ahHash = (PGPipsecAuthAttribute)
			((LPopupButton *)theDialog->
			FindPaneByID( kAHHashPopupID ))->GetValue();
		switch( mIPSECTable->mIPSECProps[propIndex].ahHash )
		{
			case kPGPike_AA_HMAC_MD5:
				mIPSECTable->mIPSECProps[propIndex].ahAuthAlg =
					kPGPike_AH_MD5;
				break;
			case kPGPike_AA_HMAC_SHA:
				mIPSECTable->mIPSECProps[propIndex].ahAuthAlg =
					kPGPike_AH_SHA;
				break;
		}
		mIPSECTable->mIPSECProps[propIndex].espHash = (PGPipsecAuthAttribute)
			( ((LPopupButton *)theDialog->
			FindPaneByID( kESPHashPopupID ))->GetValue() - 1 );
		switch( cipherPop->GetValue() )
		{
#if PGPNET_ALLOW_DES56
			case 1:
				value = kPGPike_ET_NULL;
				break;
			case 2:
				value = kPGPike_ET_DES;//kPGPike_ET_DES_IV64;
				break;
			case 3:
				value = kPGPike_ET_3DES;
				break;
			default:
			case 4:
				value = kPGPike_ET_CAST;
				break;
#else
			case 1:
				value = kPGPike_ET_NULL;
				break;
			case 2:
				value = kPGPike_ET_3DES;
				break;
			default:
			case 3:
				value = kPGPike_ET_CAST;
				break;
#endif
		}
		mIPSECTable->mIPSECProps[propIndex].espCipher =
			(PGPipsecESPTransformID)value;
		if( ( mIPSECTable->mIPSECProps[propIndex].espCipher == kPGPike_ET_NULL )
			&& ( mIPSECTable->mIPSECProps[propIndex].espHash == kPGPike_AA_None ) )
		{
			WarningAlert(	kWAStopAlertType,
								kWAOKStyle,
								STRx_AdvancedPanel,
								kInvalidIPSECID );
			goto tryAgain;
		}
		mIPSECTable->mIPSECProps[propIndex].ipcomp =
			(PGPipsecIPCOMPTransformID) ( ((LPopupButton *)theDialog->
			FindPaneByID( kIPCAlgPopupID ))->GetValue() + 1 );

		STableCell	lCell, rCell;
		
		lCell.row = rCell.row = propIndex + 1;
		lCell.col = 1;
		rCell.col = 4;
		mIKETable->RefreshCellRange( lCell, rCell );
	}
}

	void
CAdvancedPanel::ListenToMessage(
	MessageT		inMessage,
	void *			ioParam)
{
	STableCell		cell,
					ocell;
	CColumnTable *	colTable;
	PGPBoolean		selected = FALSE;
	PGPUInt32		propIndex;
	UInt32			dataSize = sizeof(PGPUInt32);
	TableIndexT		rows,
					cols;
	
	switch(inMessage)
	{
		case button_Defaults:
			if( IsntNull( mIKETable->mIKEProps ) )
			{
				PGPFreeData( mIKETable->mIKEProps );
				mIKETable->mIKEProps = NULL;
			}
			if( IsntNull( mIPSECTable->mIPSECProps ) )
			{
				PGPFreeData( mIPSECTable->mIPSECProps );
				mIPSECTable->mIPSECProps = NULL;
			}
			mIKETable->RemoveAllRows( TRUE );
			mIPSECTable->RemoveAllRows( TRUE );
					
			((LCheckBox *) FindPaneByID(checkbox_CAST))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_3DES))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_DES56))->SetValue( FALSE );
			((LCheckBox *) FindPaneByID(checkbox_NoCipher))->SetValue( FALSE );
			((LCheckBox *) FindPaneByID(checkbox_NoHash))->SetValue( FALSE );
			((LCheckBox *) FindPaneByID(checkbox_SHA))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_MD5))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_LZS))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_Deflate))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_DH768))->SetValue( FALSE );
			((LCheckBox *) FindPaneByID(checkbox_DH1024))->SetValue( TRUE );
			((LCheckBox *) FindPaneByID(checkbox_DH1536))->SetValue( TRUE );
			((LPopupButton *) FindPaneByID(popup_IPSECGroup))->SetValue( 1 );
			
			mIKETable->mIKEProps = (PGPNetPrefIKEProposalEntry *)PGPNewData(
					CPGPnet::GetMemMgr(), sizeof(sDefaultIKEProposals), 0 );
			if( IsntNull( mIKETable->mIKEProps ) )
				pgpCopyMemory( sDefaultIKEProposals, mIKETable->mIKEProps,
								sizeof(sDefaultIKEProposals) );
			mIKETable->mNumProps = sizeof(sDefaultIKEProposals) /
									sizeof(PGPNetPrefIKEProposalEntry);
			for( propIndex = 0; propIndex < mIKETable->mNumProps; propIndex++ )
			{
				mIKETable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
								sizeof( PGPUInt32 ), FALSE, TRUE );
			}
			
			mIPSECTable->mIPSECProps = (PGPNetPrefIPSECProposalEntry *)
				PGPNewData( CPGPnet::GetMemMgr(), sizeof(sDefaultIPSECProposals), 0 );
			if( IsntNull( mIPSECTable->mIPSECProps ) )
				pgpCopyMemory( sDefaultIPSECProposals, mIPSECTable->mIPSECProps,
								sizeof(sDefaultIPSECProposals) );
			mIPSECTable->mNumProps = sizeof(sDefaultIPSECProposals) /
									sizeof(PGPNetPrefIPSECProposalEntry);
			for( propIndex = 0; propIndex < mIPSECTable->mNumProps; propIndex++ )
			{
				mIPSECTable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
								sizeof( PGPUInt32 ), FALSE, TRUE );
			}
			break;
		case button_NewIKE:
			if( mIKETable->mNumProps < 16 )
				IKEProposalDialog( MAX_PGPUInt32 );
			break;
		case button_NewIPSEC:
			if( mIPSECTable->mNumProps < 16 )
				IPSECProposalDialog( MAX_PGPUInt32 );
			break;
		case button_Edit:
			if( IsntNull( mSelectedTable ) )
			{
				cell = mSelectedTable->GetFirstSelectedCell();
				if( cell.row > 0 )
				{
					mSelectedTable->GetCellData( cell, &propIndex, dataSize );
					if( mSelectedTable == mIKETable )
						IKEProposalDialog( propIndex );
					else
						IPSECProposalDialog( propIndex );
				}
			}
			break;
		case coltable_DoubleClick:
			cell = *(STableCell *)ioParam;
			if( cell.row > 0 )
			{
				mSelectedTable->GetCellData( cell, &propIndex, dataSize );
				if( mSelectedTable == mIKETable )
					IKEProposalDialog( propIndex );
				else
					IPSECProposalDialog( propIndex );
			}
			break;
		case button_Remove:
			if( IsntNull( colTable = mSelectedTable ) )
			{
				cell = colTable->GetFirstSelectedCell();
				if( cell.row > 0 )
				{
					colTable->GetCellData( cell, &propIndex, dataSize );
					colTable->GetWideOpenTableSize( rows, cols );
					if( rows > 1 )
					{
						if( colTable == mIKETable )
						{
							pgpCopyMemory( &mIKETable->mIKEProps[propIndex + 1],
								&mIKETable->mIKEProps[propIndex],
								( mIKETable->mNumProps - propIndex - 1 ) *
								sizeof(PGPNetPrefIKEProposalEntry) );
							mIKETable->mNumProps--;
						}
						else
						{
							pgpCopyMemory( &mIPSECTable->mIPSECProps[propIndex + 1],
								&mIPSECTable->mIPSECProps[propIndex],
								( mIPSECTable->mNumProps - propIndex - 1 ) *
								sizeof(PGPNetPrefIPSECProposalEntry) );
							mIPSECTable->mNumProps--;
						}
						colTable->RemoveRows( 1, cell.row, TRUE );
						for( rows--; cell.row <= rows; cell.row++ )
						{
							colTable->GetCellData( cell, &propIndex, dataSize );
							propIndex --;
							colTable->SetCellData( cell, &propIndex, dataSize );
						}
					}
					else
						SysBeep(1);
				}
			}
			break;
		case button_MoveUp:
			if( IsntNull( colTable = mSelectedTable ) )
			{
				cell = colTable->GetFirstSelectedCell();
				if( cell.row > 1 )
				{
					if( colTable == mIKETable )
					{
						PGPNetPrefIKEProposalEntry	savedIKE;
						
						pgpCopyMemory( &mIKETable->mIKEProps[ cell.row - 2 ],
							&savedIKE,
							sizeof( PGPNetPrefIKEProposalEntry ) );
						pgpCopyMemory( &mIKETable->mIKEProps[ cell.row - 1 ],
							&mIKETable->mIKEProps[ cell.row - 2 ],
							sizeof( PGPNetPrefIKEProposalEntry ) );
						pgpCopyMemory( &savedIKE,
							&mIKETable->mIKEProps[ cell.row - 1 ],
							sizeof( PGPNetPrefIKEProposalEntry ) );
					}
					else
					{
						PGPNetPrefIPSECProposalEntry	savedIPSEC;
						
						pgpCopyMemory( &mIPSECTable->mIPSECProps[ cell.row - 2 ],
							&savedIPSEC,
							sizeof( PGPNetPrefIPSECProposalEntry ) );
						pgpCopyMemory( &mIPSECTable->mIPSECProps[ cell.row - 1 ],
							&mIPSECTable->mIPSECProps[ cell.row - 2 ],
							sizeof( PGPNetPrefIPSECProposalEntry ) );
						pgpCopyMemory( &savedIPSEC,
							&mIPSECTable->mIPSECProps[ cell.row - 1 ],
							sizeof( PGPNetPrefIPSECProposalEntry ) );
					}
					ocell = cell;
					ocell.row--;
					cell.col = 4;
					colTable->RefreshCellRange( ocell, cell );
					colTable->SelectCell( ocell );
					colTable->ScrollCellIntoFrame( ocell );
				}
			}
			break;
		case button_MoveDown:
			if( IsntNull( colTable = mSelectedTable ) )
			{
				cell = colTable->GetFirstSelectedCell();
				colTable->GetWideOpenTableSize( rows, cols );
				if( ( cell.row > 0 ) && ( cell.row < rows ) )
				{
					if( colTable == mIKETable )
					{
						PGPNetPrefIKEProposalEntry	savedIKE;
						
						pgpCopyMemory( &mIKETable->mIKEProps[ cell.row ],
							&savedIKE,
							sizeof( PGPNetPrefIKEProposalEntry ) );
						pgpCopyMemory( &mIKETable->mIKEProps[ cell.row - 1 ],
							&mIKETable->mIKEProps[ cell.row ],
							sizeof( PGPNetPrefIKEProposalEntry ) );
						pgpCopyMemory( &savedIKE,
							&mIKETable->mIKEProps[ cell.row - 1 ],
							sizeof( PGPNetPrefIKEProposalEntry ) );
					}
					else
					{
						PGPNetPrefIPSECProposalEntry	savedIPSEC;
						
						pgpCopyMemory( &mIPSECTable->mIPSECProps[ cell.row ],
							&savedIPSEC,
							sizeof( PGPNetPrefIPSECProposalEntry ) );
						pgpCopyMemory( &mIPSECTable->mIPSECProps[ cell.row - 1 ],
							&mIPSECTable->mIPSECProps[ cell.row ],
							sizeof( PGPNetPrefIPSECProposalEntry ) );
						pgpCopyMemory( &savedIPSEC,
							&mIPSECTable->mIPSECProps[ cell.row - 1 ],
							sizeof( PGPNetPrefIPSECProposalEntry ) );
					}
					ocell = cell;
					ocell.row++;
					ocell.col = 4;
					colTable->RefreshCellRange( cell, ocell );
					ocell.col = 1;
					colTable->SelectCell( ocell );
					colTable->ScrollCellIntoFrame( ocell );
				}
			}
			break;
		case checkbox_DES56:
			if( *(Int32 *)ioParam == 1 )
			{
				if( WarningAlert(	kWACautionAlertType,
								kWACancelOKStyle,
								STRx_AdvancedPanel,
								kDES56WarningID ) == 1 )
					((LCheckBox *) FindPaneByID(checkbox_DES56))->
						SetValue( 0 );
			}
			break;
		case coltable_SelectChange:
			if( !mChange )
			{
				mChange = TRUE;
				colTable = (CColumnTable *)ioParam;
				cell = colTable->GetFirstSelectedCell();
				selected = ( cell.row > 0 );
				
				if( selected )
				{
					mEditButton->Enable();
					mRemoveButton->Enable();
					mMoveUpButton->Enable();
					mMoveDownButton->Enable();
					if( IsntNull( mSelectedTable) &&
						( mSelectedTable != colTable ) )
					{
						mSelectedTable->UnselectAllCells();
					}
					mSelectedTable = colTable;
				}
				else
				{
					mEditButton->Disable();
					mRemoveButton->Disable();
					mMoveUpButton->Disable();
					mMoveDownButton->Disable();
					if( mSelectedTable != colTable )
					{
						
					}
					else
					{
						mSelectedTable = NULL;
					}
				}
				mChange = FALSE;
			}
			break;
	}
}

	void
CAdvancedPanel::Load(
	void * )
{
	PGPBoolean			boolPref;
	PGPUInt32			propIndex,
						numPref;
	PGPError			err;
	SInt32				value;
	LCheckBox	*		cbox,
				*		cbox2;
	
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherCAST, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_CAST))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipher3DES, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_3DES))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherDES56, &boolPref );
	cbox = (LCheckBox *) FindPaneByID(checkbox_DES56);
	cbox->RemoveListener(this);
	cbox->SetValue( boolPref );
	cbox->AddListener(this);
	cbox2 = (LCheckBox *) FindPaneByID(checkbox_NoCipher);
#if !PGPNET_ALLOW_DES56
	{
		Rect	desRect,
				noRect;
		
		cbox->CalcPortFrameRect( desRect );
		cbox2->CalcPortFrameRect( noRect );
		cbox->Hide();
		cbox2->MoveBy( -(noRect.left - desRect.left), 0, TRUE );
	}
#endif
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherNone, &boolPref );
	cbox2->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashNone, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_NoHash))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashSHA1, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_SHA))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashMD5, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_MD5))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCompLZS, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_LZS))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCompDeflate, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_Deflate))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH768, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_DH768))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH1024, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_DH1024))->SetValue( boolPref );
	PGPGetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH1536, &boolPref );
	((LCheckBox *) FindPaneByID(checkbox_DH1536))->SetValue( boolPref );
	PGPGetPrefNumber( CPGPnet::GetNetPrefs(), kPGPnetPrefIPSECGroupID, &numPref );
	switch( numPref )
	{
		/*case kPGPike_GR_MODPOne:
			value = 2;
			break;*/
		case kPGPike_GR_MODPTwo:
			value = 2;
			break;
		case kPGPike_GR_MODPFive:
			value = 3;
			break;
		default:
		case kPGPike_GR_None:
			value = 1;
			break;
	}
	((LPopupButton *) FindPaneByID(popup_IPSECGroup))->SetValue( value );
	
	err = PGPGetNetIKEProposalPrefs( CPGPnet::GetNetPrefs(),
			&mIKETable->mIKEProps, &mIKETable->mNumProps );
	if( IsntPGPError( err ) )
		for( propIndex = 0; propIndex < mIKETable->mNumProps; propIndex++ )
		{
			mIKETable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
							sizeof( PGPUInt32 ), FALSE, TRUE );
		}
	
	err = PGPGetNetIPSECProposalPrefs( CPGPnet::GetNetPrefs(),
			&mIPSECTable->mIPSECProps, &mIPSECTable->mNumProps );
	if( IsntPGPError( err ) )
		for( propIndex = 0; propIndex < mIPSECTable->mNumProps; propIndex++ )
		{
			mIPSECTable->InsertSiblingRows( 1, 0xFFFF, &propIndex,
							sizeof( PGPUInt32 ), FALSE, TRUE );
		}
}

	void
CAdvancedPanel::Save(
	void * )
{
	PGPBoolean			boolPref;
	PGPUInt32			numPref;
	
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_CAST))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherCAST, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_3DES))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipher3DES, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_DES56))->GetValue();
#if !PGPNET_ALLOW_DES56
	boolPref = FALSE;
#endif
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherDES56, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_NoCipher))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCipherNone, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_NoHash))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashNone, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_SHA))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashSHA1, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_MD5))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowHashMD5, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_LZS))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCompLZS, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_Deflate))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowCompDeflate, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_DH768))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH768, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_DH1024))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH1024, boolPref );
	boolPref = ((LCheckBox *) FindPaneByID(checkbox_DH1536))->GetValue();
	PGPSetPrefBoolean( CPGPnet::GetNetPrefs(),
		kPGPNetPrefAllowDH1536, boolPref );
	switch( ((LPopupButton *) FindPaneByID(popup_IPSECGroup))->GetValue() )
	{
		default:
		case 1:
			numPref = kPGPike_GR_None;
			break;
		/*case 2:
			numPref = kPGPike_GR_MODPOne;
			break;*/
		case 2:
			numPref = kPGPike_GR_MODPTwo;
			break;
		case 3:
			numPref = kPGPike_GR_MODPFive;
			break;
	}
	PGPSetPrefNumber( CPGPnet::GetNetPrefs(), kPGPnetPrefIPSECGroupID, numPref );
	
	PGPSetNetIKEProposalPrefs( CPGPnet::GetNetPrefs(),
			mIKETable->mIKEProps, mIKETable->mNumProps );
	PGPSetNetIPSECProposalPrefs( CPGPnet::GetNetPrefs(),
			mIPSECTable->mIPSECProps, mIPSECTable->mNumProps );
}

CIKETable::CIKETable(LStream *inStream)
	: CColumnTable(inStream)
{
	mIKEProps = NULL;
	mNumProps = 0;
}

CIKETable::~CIKETable()
{
	if( IsntNull( mIKEProps ) )
		PGPFreeData( mIKEProps );
}

	void
CIKETable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
CIKETable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		& )
{
	PGPUInt32			propIndex;
	Uint32				dataSize = sizeof(PGPUInt32);
	TableIndexT			col;
	
	iconID;
	indentLevel;
	data;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &propIndex, dataSize );
	switch( col )
	{
		case 1:		// Auth
			GetIndString( data, STRx_IKEAuth, mIKEProps[propIndex].authMethod );
			break;
		case 2:		// Hash
			GetIndString( data, STRx_Authentication,
				mIKEProps[propIndex].hash );
			break;
		case 3:		// Cipher
			GetIndString( data, STRx_IKECipher,
				mIKEProps[propIndex].cipher );
			break;
		case 4:		// DH
			GetIndString( data, STRx_IKEGroup,
				mIKEProps[propIndex].groupID );
			break;
	}
	return FALSE;
}

CIPSECTable::CIPSECTable(LStream *inStream)
	: CColumnTable(inStream)
{
	mIPSECProps		= NULL;
	mNumProps		= 0;
}

CIPSECTable::~CIPSECTable()
{
	if( IsntNull( mIPSECProps ) )
		PGPFreeData( mIPSECProps );
}

	void
CIPSECTable::FinishCreateSelf()
{
	CColumnTable::FinishCreateSelf();
}

	Boolean
CIPSECTable::GetCellDrawData(
	STableCell			inCell,
	ResIDT				&iconID,
	Int16				&indentLevel,
	Str255				data,
	StyleParameter		& )
{
	PGPUInt32			propIndex;
	Uint32				dataSize = sizeof(PGPUInt32);
	TableIndexT			col;
	Str255				pstr;
	
	iconID;
	indentLevel;
	data;
	col = inCell.col;
	inCell.col = 1;
	GetCellData( inCell, &propIndex, dataSize );
	switch( col )
	{
		case 1:		// AH
			if( mIPSECProps[propIndex].useAH )
				GetIndString( data, STRx_Authentication,
					mIPSECProps[propIndex].ahHash );
			else
				GetIndString( data, STRx_AdvancedPanel, kNoneID );
			break;
		case 2:		// ESP
			if( mIPSECProps[propIndex].useESP )
			{
				if( mIPSECProps[propIndex].espHash != kPGPike_AA_None )
				{
					GetIndString( data, STRx_Authentication,
						mIPSECProps[propIndex].espHash );
					AppendPString( "\p, ", data );
				}
				GetIndString( pstr, STRx_Encryption,
					mIPSECProps[propIndex].espCipher );
				AppendPString( pstr, data );
			}
			else
				GetIndString( data, STRx_AdvancedPanel, kNoneID );
			break;
		case 3:		// IPCOMP
			if( mIPSECProps[propIndex].useIPCOMP )
				GetIndString( data, STRx_Compression,
					mIPSECProps[propIndex].ipcomp );
			else
				GetIndString( data, STRx_AdvancedPanel, kNoneID );
			break;
	}
	return FALSE;
}

