/*____________________________________________________________________________
	pgpDebug.h
	
	Copyright (C) 1996,1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	Assertion macro header

	$Id: pgpDebug.h,v 1.3 1999/03/10 02:49:29 heller Exp $
____________________________________________________________________________*/
#ifndef Included_pgpDebug_h	/* [ */
#define Included_pgpDebug_h

#include <stdlib.h>
#include <stdarg.h>

#include "pgpTypes.h"


/*
 * pgpFixBeforeShip is a macro which forces a compile error unless
 * the UNFINISHED_CODE_ALLOWED macro is non-zero.
 * Example:  pgpFixBeforeShip("Does this really work?")
 */
#ifndef pgpFixBeforeShip
#if UNFINISHED_CODE_ALLOWED
#define pgpFixBeforeShip(msg)
#else
#define pgpFixBeforeShip(msg)	@@@@@@ #msg @@@@@@
#endif
#endif

/*
 * DEBUG_STRUCT_CONSTRUCTOR defines a null constructor for a struct
 * which initializes the structure which all 0xDDs if PGP_DEBUG is non-zero,
 * or does nothing otherwise.  It requires C++.  It shouldn't be used
 * for anything with virtual methods, because it will overwrite the
 * virtual dispatch table pointer.
 * Example:  foo { int a; DEBUG_STRUCT_CONSTRUCTOR(foo) }
 */
/*#if defined(__cplusplus) && PGP_DEBUG
#define DEBUG_STRUCT_CONSTRUCTOR(type)						\
		type(void)											\
		{													\
			pgpDebugFillMemory(this, sizeof(*this));		\
		}
#else
*/
#define DEBUG_STRUCT_CONSTRUCTOR(type)
/*#endif*/

PGP_BEGIN_C_DECLARATIONS

/*
 * All the FmtMsg macros accept the following special sequences:
 *		%%	Replaced with a single '%'
 *		%c	Replaced with the char argument
 *		%s	Replaced with the C string argument
 *		%S	Replaced with the Pascal string argument
 *		%B	Replaced with the memory buffer as a string
 *				(two args: length (int), buffer)
 *		%lB	Replaced with the memory buffer as a string
 *				(two args: length (long), buffer)
 *		%d	Replaced with the signed integer value (base 10)
 *		%ld	Replaced with the signed long value (base 10)
 *		%u	Replaced with the unsigned integer value (base 10)
 *		%lu	Replaced with the unsigned long value (base 10)
 *		%x	Replaced with the unsigned integer value (base 16)
 *		%lx	Replaced with the unsigned long value (base 16)
 *		%o	Replaced with the unsigned integer value (base 8)
 *		%lo	Replaced with the unsigned long value (base 8)
 *		%b	Replaced with the unsigned integer value (base 2)
 *		%lb	Replaced with the unsigned long value (base 2)
 *		%p	Replaced with the pointer value, printed in hex
 */

#define pgpa(assertions)
#define pgpDebugMsgIf(cond, msg)
#define pgpDebugPStr(pStr)
#define pgpDebugFmtMsg(params)
#define pgpDebugMsg(msg)

/*
 * Convenient short-hands follow
 */

#define pgpAssert(condition)										\
		pgpa(pgpaAssert(condition))
#define pgpAssertMsg(condition, message)							\
		pgpa((														\
			pgpaAssert(condition),									\
			pgpaMsg(message)))

#define pgpAssertAddrValid(ptr, type)								\
		pgpa(pgpaAddrValid(ptr, type))
#define pgpAssertAddrValidMsg(ptr, type, message)					\
		pgpa((														\
			pgpaAddrValid(ptr, type),								\
			pgpaMsg(message)))

#define pgpAssertStrLenValid(str, minLen, maxLen)					\
		pgpa(pgpaStrLenValid(str, minLen, maxLen))
#define pgpAssertStrLenValidMsg(str, minLen, maxLen, message)		\
		pgpa((														\
			pgpaStrLenValid(str, minLen, maxLen),					\
			pgpaMsg(message)))

#define pgpAssertPStrLenValid(pstr, minLen, maxLen)					\
		pgpa(pgpaPStrLenValid(pstr, minLen, maxLen))
#define pgpAssertPStrLenValidMsg(pstr, minLen, maxLen, message)		\
		pgpa((														\
			pgpaPStrLenValid(pstr, minLen, maxLen),					\
			pgpaMsg(message)))

#define pgpAssertStrValid(str)										\
		pgpa(pgpaStrValid(str))
#define pgpAssertStrValidMsg(str, msg)								\
		pgpa((														\
			pgpaStrValid(str, minLen, maxLen),						\
			pgpaMsg(message)))

#define pgpAssertPStrValid(pstr)									\
		pgpa(pgpaPStrValid(pstr))
#define pgpAssertPStrValidMsg(pstr, message)						\
		pgpa((														\
			pgpaPStrValid(pstr, minLen, maxLen),					\
			pgpaMsg(message)))


#define pgpAssertNoErr( err ) 	pgpAssert( IsntPGPError( err ) || 	\
		err == kPGPError_UserAbort )
#define pgpAssertErrWithPtr(err, ptr) \
		pgpAssert( ( IsntPGPError( err ) && (ptr) != NULL ) || \
		( IsPGPError( err ) && (ptr) == NULL ) )
		
/*		
int			pgpFormatVAStr(uchar *buffer, int bufferSize,
				PGPBoolean putLengthPrefix, PGPBoolean putNullTerminator,
				PGPBoolean canonicalizeNLs, char const *formatStr,
				va_list args);
uchar *		pgpFormatHStr(uchar *buffer, int bufferSize,
						PGPBoolean canonicalizeNLs, char const *formatStr, ...);
uchar *		pgpFormatPStr(uchar *buffer, int bufferSize,
						PGPBoolean canonicalizeNLs, char const *formatStr, ...);
uchar *		pgpFormatPStr255(uchar *buffer, PGPBoolean canonicalizeNLs,
						char const *formatStr, ...);
char *		pgpFormatStr(char *buffer, int bufferSize,
					PGPBoolean canonicalizeNLs,
					char const *formatStr, ...);

*/
#define pgpDebugWhackMemory( buffer, length )	/* nothing */

PGP_END_C_DECLARATIONS


#endif /* ] Included_pgpDebug_h */


/*__Editor_settings____

	Local Variables:
	tab-width: 4
	End:
	vi: ts=4 sw=4
	vim: si
_____________________*/
