/*____________________________________________________________________________
	Copyright (C) 1996-1999 Network Associates, Inc.
	All rights reserved.

	$Id: CPFTAppleTalk.cp,v 1.4.10.1 1999/07/09 00:02:37 heller Exp $
____________________________________________________________________________*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <UEnvironment.h>

#include "CPFTAppleTalk.h"

#include "PGPFMacUtils.h"
#include "CPFWindow.h"
#include "CControlThread.h"
#include "CPFPackets.h"
#include "CStatusPane.h"

#define MAXDDPRINGS			6		//note: this number and the next must be synchronized
#define MAXDDPCALLTRIES		17		//to avoid overringing.


char gPGPFNBPTypeStr[]="PGPFoneDDP";
char gNBPName[64] = "";

static pascal void OTNotifyProc(CPFTAppleTalk *context, OTEventCode code,
									OTResult result, void */*cookie*/)
{
	switch(code)
	{
		case T_DATA:
			context->mDataReady = TRUE;
			break;
		case T_BINDCOMPLETE:
			context->mOTResult = result;
			LThread::ThreadAsynchronousResume(context->mThread);
			break;
		case T_UNBINDCOMPLETE:
			context->mOTResult = result;
			LThread::ThreadAsynchronousResume(context->mThread);
			break;
		case T_RESOLVEADDRCOMPLETE:
			context->mOTResult = result;
			LThread::ThreadAsynchronousResume(context->mThread);
			break;
	}
	return;
}

CPFTAppleTalk::CPFTAppleTalk(CPFWindow *cpfWindow, LThread */*thread*/, short *result)
					:	CPFTransport(cpfWindow)
{
	OSStatus err;

	*result = noErr;
	mOTResult = 0;
	mEndpoint = NIL;
	mMore = mDataReady = FALSE;
	if(!UEnvironment::HasFeature(env_HasOpenTransport))
		*result = _pge_PortNotAvail;
	if(!*result)
	{
		err = MakeOTEndpoint();
		if(err)
			*result = err;
	}
	if(*result)
		PGFAlert("Open Transport AppleTalk services could not be opened!", 0);
}

CPFTAppleTalk::~CPFTAppleTalk()
{
	AbortSync();
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
		Disconnect();
	CloseOTEndpoint();
}

OSErr
CPFTAppleTalk::MakeOTEndpoint()
{
	TEndpointInfo info;
	OTConfiguration *config;
	OSStatus err = 0;
	TBind req, ret;
    char sp[128];
    StringHandle sh;
	
	if(!mEndpoint)
	{
		config = OTCreateConfiguration(kDDPName);
		mEndpoint = OTOpenEndpoint(config, 0, &info, &err);
		if(!err)
		{
			OTSetSynchronous(mEndpoint);
			OTInstallNotifier(mEndpoint, (OTNotifyProcPtr)&OTNotifyProc, this);
			OTInitDDPAddress(&mLastAddress, 0,0,0, PGPFDDPTYPE);
			OTInitDDPAddress(&mRemoteAddress, 0,0,0, PGPFDDPTYPE);
			if(sh = GetString(-16413))	// sharing name from System file
			{
				HLock((Handle)sh);
				pstrcpy((uchar *)gNBPName, *sh);
				p2cstr((uchar *)gNBPName);
				HUnlock((Handle)sh);
				ReleaseResource((Handle)sh);
			}
			else
				strcpy(gNBPName, "PGPFone");
			strcpy(sp, gNBPName);strcat(sp, ":");strcat(sp, gPGPFNBPTypeStr);
			strcat(sp, "@*");
			mAddressLen = OTInitDDPNBPAddress(&mAddress, sp, 0,0,0, PGPFDDPTYPE);
			req.addr.len = mAddressLen;
			req.addr.buf = (uchar *)&mAddress;
			req.qlen = 1;
			ret.addr.maxlen = sizeof(DDPAddress);
			ret.addr.buf = (uchar *) &mRemoteAddress;
			err = OTBind(mEndpoint, &req, &ret);
			if(err == kOTBadNameErr)
				PGFAlert("Invalid AppleTalk address.",0);
			OTSetAsynchronous(mEndpoint);
		}
	}
	return err;
}

OSErr
CPFTAppleTalk::CloseOTEndpoint()
{
	OSErr err = 0;
	
	if(mEndpoint)
	{
		OTRemoveNotifier(mEndpoint);
		err = OTCloseProvider(mEndpoint);
		pgpAssert(!err);
		mEndpoint = NIL;
	}
	return err;
}

PGErr
CPFTAppleTalk::Connect(ContactEntry *con, short *connectResult)
{
	SndListHandle respSound = NIL;
	SndChannelPtr respSndChannel = NIL;
	TBind req, ret;
	NBPAddress nbpaddr;
	size_t nbpSize;
	char buf[MAXPGPFDDPSIZE], sp[128];
	uchar *p;
	short channel;
	long len, nextTry;
	ulong respSoundDelay;
	Boolean found = FALSE;
	OSErr err=0;
	OSStatus oterr;
	
	mTMutex->Wait(semaphore_WaitForever);
	SetState(_cs_connecting);
	mThread = LThread::GetCurrentThread();
	*connectResult = _cr_Error;
	if(con->nbpZone[0] && con->nbpListener[0])
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Contacting...");
		if(!mAbort)
		{
			strcpy(sp, con->nbpListener);strcat(sp, ":");strcat(sp, gPGPFNBPTypeStr);
			strcat(sp, "@");strcat(sp, con->nbpZone);
			nbpSize=OTInitNBPAddress(&nbpaddr, sp);
			OTInitDDPAddress(&mRemoteAddress, 0,0,0,PGPFDDPTYPE);
			req.addr.len = nbpSize;
			req.addr.buf = (uchar *)&nbpaddr;
			req.qlen = 1;
			ret.addr.maxlen = sizeof(DDPAddress);
			ret.addr.buf = (uchar *)&mRemoteAddress;
			oterr = OTResolveAddress(mEndpoint, &req, &ret, 5000);
			mThread->Block();
			if(!oterr && !mOTResult && !mAbort)
			{
				CStatusPane::GetStatusPane()->AddStatus(0, "AppleTalk lookup successful...");
				for(short tries=MAXDDPCALLTRIES;(*connectResult == _cr_Error) && tries>0 && !mAbort;
					tries--)
				{
					buf[0] = _hpt_Setup;
					buf[1] = _ptip_Call;	len = 2;
					if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
						gPGFOpts.popt.identity[0])
					{
						len+= (buf[2] = strlen(gPGFOpts.popt.identity)) + 1;
						strcpy(&buf[3], gPGFOpts.popt.identity);
					}
					WriteBlock(buf, &len, _pfc_Control);
					nextTry = LMGetTicks() + 120;
					while(!mAbort && nextTry > LMGetTicks())
					{
						if(len = Read(buf, MAXPGPFDDPSIZE, &channel))
							if(OTCompareDDPAddresses(&mLastAddress, &mRemoteAddress))
							{
								p = (uchar *)buf;
								if(*p++ == _hpt_Setup)
									switch(*p++)
									{
										case _ptip_Accept:
											*connectResult = _cr_Connect;
											break;
										case _ptip_Busy:
											CStatusPane::GetStatusPane()->AddStatus(0, "Busy.");
											*connectResult = _cr_Busy;
											if(gPGFOpts.popt.playRing &&
												(respSound = (SndListHandle)GetNamedResource('snd ',
												"\pBusy")))
											{
												HLock((Handle)respSound);
												if(!respSndChannel)
													SndNewChannel(&respSndChannel, 0, 0, NIL);
												// play a "busy" sound
												respSoundDelay = LMGetTicks() + 100;
												SndPlay(respSndChannel, respSound, 1);
												while(respSoundDelay > LMGetTicks())
													LThread::Yield();
											}
											break;
										case _ptip_ProbeResponse:
											if(!found)
											{
												found = TRUE;
												CStatusPane::GetStatusPane()->AddStatus(0,
														"Remote contacted, ringing.");
												if(gPGFOpts.popt.playRing &&
													(respSound = (SndListHandle)GetNamedResource('snd ',
														"\pBRing")))
												{
													HLock((Handle)respSound);
													if(!respSndChannel)
														SndNewChannel(&respSndChannel, 0, 0, NIL);
													// play a local "bring" sound
													SndPlay(respSndChannel, respSound, 1);
												}
											}
											break;
										case _ptip_Message:
											ReceiveDDPMsg(p, len -2);
											break;
									}
								break;
							}
						mThread->Yield();
					}
				}
			}
			else
				CStatusPane::GetStatusPane()->AddStatus(0, "Name lookup failed.");
			/*if(*connectResult != _cr_Connect)
			{
				CloseOTEndpoint();
				MakeOTEndpoint();
			}*/
		}
	}
	else
	{
		PGFAlert("No AppleTalk address has been specified.",0);
		err = _pge_NoSrvrName;
	}
	if(*connectResult != _cr_Connect)
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Connection failed.");
		SetState(_cs_none);
	}
	else
	{
		CStatusPane::GetStatusPane()->AddStatus(0, "Connected.");
		SetState(_cs_connected);
	}
	if(respSound)
		HUnlock((Handle)respSound);
	if(respSndChannel)
		SndDisposeChannel(respSndChannel, 0);
	mTMutex->Signal();
	return err;
}

PGErr
CPFTAppleTalk::Disconnect()
{
	OSErr result=0;
	
	mTMutex->Wait(semaphore_WaitForever);
	if(mState == _cs_connected)
	{
		SetState(_cs_disconnecting);
		OTInitDDPAddress(&mLastAddress, 0,0,0, PGPFDDPTYPE);
		OTInitDDPAddress(&mRemoteAddress, 0,0,0, PGPFDDPTYPE);
		/*CloseOTEndpoint();
		MakeOTEndpoint();*/
	}
	SetState(_cs_none);
	mTMutex->Signal();
	return result;
}

PGErr
CPFTAppleTalk::Listen(Boolean /*answer*/)
{
	short result=0, reply=_cr_NoReply, rings, slen, channel;
	ulong nextRingTime, len;
	long resplen;
	SndListHandle ringSound = NIL;
	SndChannelPtr ringSndChannel = NIL;
	uchar *p, buf[MAXPGPFDDPSIZE];
	DDPAddress savedAddress;
	char remoteName[64], responsepkt[128];
	Boolean sendResp, goodaddr, noted;

	mThread = LThread::GetCurrentThread();
	mTMutex->Wait(semaphore_WaitForever);
	SetState(_cs_listening);
	do
	{
		if(mAnswer)
		{	// accept
			responsepkt[0] = _hpt_Setup;
			responsepkt[1] = _ptip_Accept;	resplen = 2;
			WriteBlockTo(responsepkt, &resplen, &mLastAddress);
			pgp_memcpy(&mRemoteAddress, &mLastAddress, sizeof(DDPAddress));
			CStatusPane::GetStatusPane()->AddStatus(0, "Connected.");
			SetState(_cs_connected);
			break;
		}
		if((mState == _cs_calldetected) && (nextRingTime <= pgp_getticks()))
		{	// ring every 5.5 seconds
			if(rings++ >= MAXDDPRINGS)
				SetState(_cs_listening);
			else
			{
				if(!noted)
				{
					CStatusPane::GetStatusPane()->AddStatus(0,
						"Incoming call...");
					noted = TRUE;
				}
				if(gPGFOpts.popt.playRing &&
					(ringSound = (SndListHandle)GetNamedResource('snd ', "\pRing")))
				{
					HLock((Handle)ringSound);
					if(!ringSndChannel)
						SndNewChannel(&ringSndChannel, 0, 0, NIL);
					// ring the "phone"
					SndPlay(ringSndChannel, ringSound, 1);
				}
				nextRingTime = pgp_getticks() + 5500;
			}
		}
		sendResp = FALSE;
		goodaddr = FALSE;
		pgp_memcpy(&savedAddress, &mLastAddress, sizeof(DDPAddress));
		if(len = Read(buf, MAXPGPFDDPSIZE, &channel))
		{
			p=buf;
			if(*p++==_hpt_Setup)
				switch(*p++)
				{
					case _ptip_Call:
						if(mState != _cs_calldetected)
						{
							goodaddr = TRUE;
							remoteName[0]=0;
							if(len > 2)
							{
								if((slen = *p++) && (len-3 >= slen))
								{
									if(slen > 63)
										slen = 63;
									pgp_memcpy(remoteName, p, slen);
									remoteName[slen]=0;
									mPFWindow->GetControlThread()->SetRemoteName(remoteName);
								}
							}
							SetState(_cs_calldetected);
							nextRingTime = pgp_getticks();
							rings = 0;
							sendResp = TRUE;
							noted = FALSE;
						}
						break;
					case _ptip_Probe:
						sendResp = TRUE;
						break;
					case _ptip_Message:
						ReceiveDDPMsg(p, len -2);
						break;
				}
		}
		if(sendResp)
		{
			responsepkt[0] = _hpt_Setup;
			responsepkt[1] = _ptip_ProbeResponse;	resplen = 2;
			if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
				gPGFOpts.popt.identity[0])
			{
				resplen+= (responsepkt[2] = strlen(gPGFOpts.popt.identity)) + 1;
				strcpy(&responsepkt[3], gPGFOpts.popt.identity);
			}
			WriteBlockTo(responsepkt, &resplen, &mLastAddress);
			sendResp = FALSE;
		}
		if(!goodaddr)
			pgp_memcpy(&mLastAddress, &savedAddress, sizeof(DDPAddress));
		LThread::Yield();
	} while(!mAbort);
	if(mState != _cs_connected)
	{
		/*CloseOTEndpoint();
		MakeOTEndpoint();*/
	}
	if(ringSound)
		HUnlock((Handle)ringSound);
	if(ringSndChannel)
		SndDisposeChannel(ringSndChannel, 1);
	if(!mAnswer && mAbort)
		result = _pge_InternalAbort;
	mAnswer = FALSE;
	mTMutex->Signal();
	return result;
}

PGErr
CPFTAppleTalk::Reset()
{
	mAbort = FALSE;
	return noErr;
}

long
CPFTAppleTalk::Read(void *data, long max, short *channel)
{
	long len = 0, rdlen;
	char rdpkt[128];
	
	// return one packet if available
	TUnitData unitdata;
	OTFlags flags;
	OSStatus err;

	*channel = _pfc_Control;
	if(mDataReady)
	{
		mDataReady = FALSE;
		mMore = TRUE;
	}
	if(data && max && mMore)
	{
		unitdata.addr.maxlen = sizeof(DDPAddress);
		unitdata.addr.buf = (uchar *)&mLastAddress;
		unitdata.opt.maxlen = 0;
		unitdata.opt.buf = 0;
		unitdata.udata.maxlen = max;
		unitdata.udata.buf = (uchar *)data;
		err = OTRcvUData(mEndpoint, &unitdata, &flags);
		if(err == kOTNoDataErr)
		{
			len = 0;
			mMore = FALSE;
		}
		else
		{
			if(err)			//usually just flow control
				len = 0;
			else
				len = unitdata.udata.len;
		}
	}
	if(len && ((mState == _cs_connected) && (!OTCompareDDPAddresses(&mLastAddress, &mRemoteAddress))))
	{
		uchar *p = (uchar *)data;
		
		if(*channel == _pfc_Control)
		{
			if(*p++==_hpt_Setup)
				switch(*p++)
				{
					case _ptip_Call:
						// We are already connected.  Send back a busy notice.
						rdpkt[0] = _hpt_Setup;
						rdpkt[1] = _ptip_Busy;	rdlen = 2;
						WriteBlockTo(rdpkt, &rdlen, &mLastAddress);
						break;
					case _ptip_Probe:
						// We are already connected, but we don't report that to a probe.
						// The idea is that we only reveal our status if the other
						// party is also revealing its information.
						rdpkt[0] = _hpt_Setup;
						rdpkt[1] = _ptip_ProbeResponse;	rdlen = 2;
						if(gPGFOpts.popt.idUnencrypted && gPGFOpts.popt.idOutgoing &&
							gPGFOpts.popt.identity[0])
						{
							rdlen+= (rdpkt[2] = strlen(gPGFOpts.popt.identity)) + 1;
							strcpy(&rdpkt[3], gPGFOpts.popt.identity);
						}
						WriteBlockTo(rdpkt, &rdlen, &mLastAddress);
						break;
					case _ptip_Message:
						ReceiveDDPMsg(p, len -2);
						break;
				}
		}
		len = 0;
	}
	else if((mState == _cs_connected) && (*channel == _pfc_Control) && (*(uchar *)data == _hpt_Setup))
		return 0;	// do not pass setup packets to the packet layer
	return len;
}

void
CPFTAppleTalk::ReceiveDDPMsg(uchar */*msg*/, long /*len*/)
{
	//not implemented yet
}

OSStatus
CPFTAppleTalk::ClearLookErr(EndpointRef endpoint)
{
	OSStatus err;
	
	err = OTLook(endpoint);
	if(err == T_UDERR)
	{
		TUDErr tuderr;
		DDPAddress erraddr;
		uchar optbuf[255];
		
		// The most common error we get is the EADDRNOTAVAIL
		// error.  This means that a packet was sent on a
		// particular port number and there was no listener
		// on the other end so we received an ICMP reply
		// stating the port was not available.  We need to
		// read the error in order to clear it or we'll never
		// be able to send another packet on this port again.
		
		tuderr.addr.maxlen = sizeof(DDPAddress);
		tuderr.addr.buf = (uchar *)&erraddr;
		tuderr.opt.maxlen = 255;
		tuderr.opt.buf = optbuf;
		err = OTRcvUDErr(endpoint, &tuderr);
		//pgpAssert(0);
	}
	return err;
}

PGErr
CPFTAppleTalk::WriteBlockTo(void *buffer, long *count, DDPAddress *addr)
{
	OSStatus err = kOTNoError;
	TUnitData unitdata;
	
	mTMutex->Wait(semaphore_WaitForever);
	// Send a datagram
	unitdata.opt.len = 0;
	unitdata.opt.buf = (uchar *)NIL;
	unitdata.addr.len = sizeof(DDPAddress);
	unitdata.addr.buf = (uchar *)addr;
	unitdata.udata.len = *count;
	unitdata.udata.buf = (uchar *)buffer;
	err = OTSndUData(mEndpoint, &unitdata);
	if(err == kOTLookErr)
		ClearLookErr(mEndpoint);
	mTMutex->Signal();
	return err;
}

PGErr
CPFTAppleTalk::WriteBlock(void *buffer, long *count, short /*channel*/)
{
	return WriteBlockTo(buffer, count, &mRemoteAddress);
}

PGErr
CPFTAppleTalk::WriteAsync(long count, short /*channel*/, AsyncTransport *async)
{
	OSStatus err = kOTNoError;
	TUnitData unitdata;
	
	mTMutex->Wait(semaphore_WaitForever);
	// Send a datagram
	pgpAssert(count<=MAXPGPFDDPSIZE);
	unitdata.addr.len = sizeof(DDPAddress);
	unitdata.addr.buf = (uchar *)&mRemoteAddress;
	unitdata.opt.len = 0;
	unitdata.opt.buf = 0;
	unitdata.udata.len = count;
	unitdata.udata.buf = (uchar *)async->buffer;
	err = OTSndUData(mEndpoint, &unitdata);
	if(err == kOTLookErr)
		err = ClearLookErr(mEndpoint);
	//Errors here usually are just kOTFlowErr which should be ignored.
	//pgpAssert(!err);
	mTMutex->Signal();
	return err;
}

