/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CBlindWriteQueue.h,v 1.4 1999/03/10 02:32:01 heller Exp $
____________________________________________________________________________*/

#pragma once

#if BLIND_WRITES	// [


struct RequestHeader;

class CBlindWriteQueue
	{
	enum { kDefaultBufferSize	= 128 * 1024UL };
	
	Boolean			mGoingAway;
	
	void *			mBuffer;
	ulong			mBufferSize;
	struct
		{
		RequestHeader *	head;
		ulong			maxFreeBytes;
		ulong			curFreeBytes;
		} mFreeList;

	void			CreateFreeList( void );
	void			MergeWithNext( RequestHeader *	request);
	RequestHeader *	Allocate( ulong size );
	void			Deallocate( RequestHeader *request );
	
	static pascal void	sCompletionProc( void );
	
					CBlindWriteQueue( ulong size = kDefaultBufferSize );
	
public:
	static OSErr	Create( CBlindWriteQueue ** writer,
							ulong size = kDefaultBufferSize);
	virtual			~CBlindWriteQueue( void );
	
	enum RequestResult{ kRequestHandled = 23, kRequestNotHandled };
	RequestResult	HandleRequest( const ParamBlockRec * pb );
	
	void			WaitIODone( void );

#if PGP_DEBUG
	static void		Test( void );
	static void		TestOddEven( void );
	static void		TestDeallocateCombinations( void );
#endif
	};
	
	
#endif	// ] BLIND_WRITES