/*____________________________________________________________________________
	Copyright (C) 1996-1998 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	$Id: CipherProcGlue.c,v 1.8 1999/03/10 02:24:36 heller Exp $
____________________________________________________________________________*/

#include "pgpMacMemory.h"

#include "CipherProcGlue.h"
#include "CipherProc.h"



const OSType	kCipherProcPPCResType	= 'CPpc';
const short		kCipherProcPPCResID		= 1000;
const OSType	kCipherProc68KResType	= 'CP68';
const short		kCipherProc68KResID		= 1000;



	
typedef struct CipherProcStruct
{
	Boolean				exists;
	Boolean				isPPC;
	CipherProcUPP		entry;
	CFragConnectionID	connectionID;
	Handle				codeHandle;
	
} CipherProcStruct;

inline CipherProcStruct *	RefToStruct( CipherProcRef ref )
								{ return( (CipherProcStruct *)ref ); }
inline CipherProcRef		StructToRef( CipherProcStruct * ref )
								{ return( (CipherProcRef)ref ); }
	

	static OSErr
GetPPCCipherProc(
	CipherProcUPP *		entryPoint,
	CFragConnectionID *	connectionID,
	Handle *			codeHandle)
{
	OSErr	err	= noErr;
	Handle				ppcCRHandle = nil;
	CFragSymbolClass	theSymClass;
	
	ppcCRHandle	= Get1Resource( kCipherProcPPCResType, kCipherProcPPCResID );
	if( IsntNull( ppcCRHandle ) )
	{
		Str255	errName;
		Ptr		mainAddress;

		pgpAssert( HandleZone( ppcCRHandle ) == SystemZone() );
		
		HLock(ppcCRHandle);
		DetachResource(ppcCRHandle);
		err = GetMemFragment(*ppcCRHandle, GetHandleSize(ppcCRHandle),
				"\pPGPDiskPPC", kPrivateCFragCopy, connectionID, &mainAddress,
				errName);
		if ( IsntErr( err ) )
		{
			MacLeaks_IgnoreItem( ppcCRHandle );
			err = FindSymbol( *connectionID, "\pcipherRD", (Ptr *)entryPoint,
						&theSymClass);
			pgpAssert( theSymClass == kDataCFragSymbol );
			
			*codeHandle = ppcCRHandle;
		}
		else
		{
			DisposeHandle( ppcCRHandle );
		}
	}
	else
	{
		pgpDebugPStr( "\pGetPPCCipherProc: can't load cipher proc" );
		err	= memFullErr;
	}
		
	AssertNoErr( err, "GetPPCCipherProc" );
	return( err );
}
	
	
		

	static OSErr
Get68KCipherProc(
	CipherProcUPP *		entryPoint,
	Handle *			codeHandle)
{
	OSErr				err	= noErr;
	Handle				codeRes = nil;
		
	codeRes	= Get1Resource( kCipherProc68KResType, kCipherProc68KResID );
	if( IsntNull( codeRes ) )
	{
		pgpAssert( HandleZone( codeRes ) == SystemZone() );
		
		HLock( codeRes );
		DetachResource( codeRes );
		MacLeaks_IgnoreItem( codeRes );
		
		*codeHandle	= codeRes;
		*entryPoint	= (CipherProcUPP)*codeRes;
	}
	else
	{
		pgpDebugPStr( "\pGet68KCipherProc: can't load cipher proc" );
		err	= memFullErr;
	}
		
	AssertNoErr( err, "GetPPCCipherProc" );
	return( err );
}
	
	
	
	
	static OSErr
InitCipherProc( CipherProcStruct *ref )
{
	OSErr	err	= noErr;
	long	architecture;
	
	pgpClearMemory( ref, sizeof( *ref ) );
	
	err	= Gestalt( gestaltSysArchitecture, &architecture );
	
	if( IsntErr( err ) && architecture == gestaltPowerPC )
	{
		ref->isPPC	= TRUE;
		
		err	= GetPPCCipherProc( &ref->entry, &ref->connectionID, &ref->codeHandle );
	}
	else
	{
		ref->isPPC	= false;
		
		err	= Get68KCipherProc( &ref->entry, &ref->codeHandle );
	}
		
	ref->exists	= IsntErr( err );

	AssertNoErr( err, "CDriver::InitCipherProc" );
	return( err );
}
	
	
	

	static void
DisposeCipherProc( CipherProcStruct *ref )
{
	if ( ref->exists )
	{
		if ( ref->isPPC )
		{
			CloseConnection( &ref->connectionID );
		}
		
		if( ref->codeHandle != NULL )
		{
			DisposeHandle( ref->codeHandle );
		}
		
		pgpClearMemory( ref, sizeof( *ref ) );
	}
}
	

#pragma mark -




	OSErr
CipherProc_Load( CipherProcRef *resultRef )
{
	OSStatus			err	= noErr;
	CipherProcStruct *	ref;
	
	ref	= (CipherProcStruct *)NewPtrSys( sizeof( CipherProcStruct ) );
	if ( IsntNull( ref ) )
	{
		err	= InitCipherProc( ref );
		if ( IsErr( err ) )
		{
			DisposePtr( (Ptr)ref );
		}
		
		*resultRef	= (CipherProcRef)ref;
	}
	else
	{
		err	= memFullErr;
	}
	
	return( err );
}
	
	
	OSErr
CipherProc_Dispose( CipherProcRef	ref )
{
	OSErr	err	= noErr;
	
	DisposeCipherProc( (CipherProcStruct *)ref );
	DisposePtr( (Ptr)ref );
	err	= MemError();
	
	return( err );
}
	

#pragma mark -

	inline void
InitAPI(
	CipherProcAPIStruct *	api,
	CipherOp				op,
	const CipherContext *	context = nil)
{
	pgpClearMemory( api, sizeof( api ) );
	api->op			= op;
	api->context	= context;
}
	
	
	inline OSStatus
MyCallCipherProc(
	CipherProcStruct *		info,
	CipherProcAPIStruct *	api)
{
	return( CallCipherProcX( info->entry, api ) );
}
	
	
	OSStatus
CipherProc_CallInitContext(
	CipherProcRef	ref,
	CipherContext *	context,
	const uchar *	keyToExpand )
{
	CipherProcAPIStruct	api;
	OSErr				err	= noErr;
	
	InitAPI( &api, kCipherOp_Init, context );
	api.doInit.keyToExpand	= keyToExpand;
	
	err	= MyCallCipherProc( RefToStruct( ref ), &api );
	
	return( err );
}
	
	
	
	OSStatus
CipherProc_CallVerify( CipherProcRef ref )
{
	CipherProcAPIStruct	api;
	OSErr				err	= noErr;
	
	InitAPI( &api, kCipherOp_Verify );
	
	err	= MyCallCipherProc( RefToStruct( ref ), &api );
	
	return( err );
}
	
	
	OSStatus
CipherProc_CallEncrypt(
	CipherProcRef			ref,
	const CipherContext *	context,
	ItemCount				startBlock,
	ItemCount				numBlocks,
	const void *			src,
	void *					dest )
{
	CipherProcAPIStruct	api;
	OSErr				err	= noErr;
	
	InitAPI( &api, kCipherOp_Encrypt, context);
	api.doCipher.startBlock	= startBlock;
	api.doCipher.numBlocks	= numBlocks;
	api.doCipher.src		= src;
	api.doCipher.dest		= dest;
	
	err	= MyCallCipherProc( RefToStruct( ref ), &api );
	
	return( err );
}
	
	
	OSStatus
CipherProc_CallDecrypt(
	CipherProcRef			ref,
	const CipherContext *	context,
	ItemCount				startBlock,
	ItemCount				numBlocks,
	const void *			src,
	void *					dest )
{
	CipherProcAPIStruct	api;
	OSErr				err	= noErr;
	
	InitAPI( &api, kCipherOp_Decrypt, context);
	api.doCipher.startBlock	= startBlock;
	api.doCipher.numBlocks	= numBlocks;
	api.doCipher.src		= src;
	api.doCipher.dest		= dest;
	
	err	= MyCallCipherProc( RefToStruct( ref ), &api );
	
	return( err );
}







