#!/bin/sh

# Where should we get the pre-compiled program from ??
#
case `uname -s` in
OSF*)		myarch=alpha-dec-osf2.0
		;;
[Ll]inux)       case `uname -m` in
                ppc*)   myarch=ppc-unknown-linux2.0
                        ;;
                *86*)   myarch=x86-unknown-linux-elf
                        ;;
                esac
                ;;
*BSD*)		myarch=x86-unknown-bsd
		;;
IRIX*)		case `uname -r` in
		6*)	myarch=mips-sgi-irix6.2
			;;
		5.3*)	myarch=mips-sgi-irix5.3
			;;
		*)	myarch=mips-sgi-irix5.2
			;;
		esac
		;;
SunOS)		case `uname -p 2>/dev/null` in
		sparc*) case `uname -r` in
			5.3)	myarch=sparc-sun-solaris2.3
				echo
				echo "** Please note that the Fortify for Netscape distributions"
				echo "no longer contain pre-compiled binaries for Solaris 2.3."
				echo "You will need to compile the program yourself from the source"
				echo "code before proceeding further."
				echo
				;;
			5.*)	myarch=sparc-sun-solaris2.4
				;;
			*)	myarch=sparc-sun-sunos4.1.3_U1
				echo
				echo "** Please note that the Fortify for Netscape distributions"
				echo "no longer contain pre-compiled binaries for SunOS 4.1.3."
				echo "You will need to compile the program yourself from the source"
				echo "code before proceeding further."
				echo
				;;
			esac
			;;
		*86*)	myarch=x86-sun-solaris2.4
			;;
		*)	myarch=sparc-sun-sunos4.1.3_U1
			;;
		esac
		;;
*)		myarch=src
		;;
esac

# Change directory to the top level Fortify directory, so that
# the various support files and architecture dirs can be found.
#
if expr "$0" : '.*/' > /dev/null
then
	cd `dirname $0`
else
	for d in `echo $PATH | sed -e 's/:/ /g'`
	do
		if [ -f "$d/Fortify.sh" -a -x "$d/Fortify.sh" ]
		then
			cd $d
			break
		fi
	done
fi

# Compiled programs in the src directory take preference
# over the pre-compiled versions....
#
PATH=./src/cmdline:./$myarch/bin:$PATH
export PATH

exec fortify $*
