/* $Id: main.c,v 1.1 1997/12/02 19:25:28 gordo Exp $ */
/*
 * ISAKMP daemon main loop.
 *
 * Copyright (C) 1997, Gordon Oliver
 *              This program is free software; you can redistribute it and/or
 *              modify it under the terms of the GNU General Public License
 *              as published by the Free Software Foundation; either version
 *              2 of the License, or (at your option) any later version.
 *
 */
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/fcntl.h>
#include <ctype.h>
#include <netdb.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <linux/pfkeyv2.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define ISAKMP_PORT_FILE	"ports"

#define MAX_UDP_PORTS	10
int udp_ports[MAX_UDP_PORTS];
int n_udp;

int
bind_ports()
{
    FILE *fp;
    char line[120];
    struct sockaddr_in sin;
    char *point, *end;
    int len, udp, i;

    n_udp = 0;
    fp = fopen(ISAKMP_PORT_FILE, "r");
    if (!fp)
	return -1;
    sethostent(1);
    while (fgets(line, 120, fp))
    {
	len = strlen(line);
	if (line[len-1] != '\n') {
	    /* FIXME: syslog malformed line */
	    return -1;
	}
	if (line[0] == '#')
	    continue;
	end = index(line, ':');
	if (end)
	    *end++ = '\0';
	len = strlen(line);
	if (len < 7 || len > 15) {
	    /* FIXME: syslog malformed line */
	    return -1;
	}
	if (isdigit(line[0])) {
	    point = line;
	    for (i = 0; i < 3; i++) {
		point = index(point, '.');
		if (!point) {
		    /* FIXME: syslog malformed line */
		    return -1;
		}
		point += 1;
	    }
	    point = index(point, '.');
	    if (point) {
		/* FIXME: syslog malformed line */
		return -1;
	    }
	    sin.sin_family = AF_INET;
	    sin.sin_addr.s_addr = inet_addr(line);
	} else {
	    struct hostent *he;

	    he = gethostbyname(line);
	    if (!he) {
		/* FIXME: syslog no host */
		herror(line);
		continue;
	    }
	    if (he->h_addrtype != AF_INET) {
		/* FIXME: syslog no host */
		fprintf(stderr, "host addr not AF_INET\n");
		continue;
	    }
	    if (he->h_length != sizeof sin) {
		/* FIXME: syslog no host */
		fprintf(stderr, "host addr len incorrect %d != %d\n",
			he->h_length, sizeof sin);
		continue;
	    }
	    memcpy(&sin, he->h_addr_list[0], sizeof sin);
	}
	if (end) {
	    char *nullptr;
	    sin.sin_port = strtol(end, &nullptr, 0);
	    if (nullptr == end) {
		/* FIXME: syslog no host */
		continue;
	    }
	}
	else
	    sin.sin_port = 500;
	udp = socket(AF_INET, SOCK_DGRAM, 17);
	if (udp < 0) {
	    perror("socket");
	    break;
	}
	if (bind(udp, (struct sockaddr *)&sin, sizeof sin)) {
	    /* FIXME: syslog no host */
	    perror(line);
	    close(udp);
	    continue;
	}
	udp_ports[n_udp++] = udp;
    }
    endhostent();
    return 0;
}

void
loop(int pfkey, int dev_ipsec)
{
    fd_set rd, rdorig;
    int i, count, max;

    FD_ZERO(&rdorig);
    max = -1;
    FD_SET(pfkey, &rdorig);
    if (max < pfkey)
	max = pfkey;
    FD_SET(dev_ipsec, &rdorig);
    if (max < dev_ipsec)
	max = dev_ipsec;
    for (i = 0; i < n_udp; i++) {
	FD_SET(udp_ports[i], &rdorig);
	if (max < udp_ports[i])
	    max = udp_ports[i];
    }
    while (1) {
	memcpy(&rd, &rdorig, sizeof rdorig);
	count = select(max+1, &rd, NULL, NULL, NULL);
	if (count < 0)
	    return;
	if (FD_ISSET(pfkey, &rd)) {
	    do_pfkey_read(pfkey);
	    count -= 1;
	}
	if (FD_ISSET(dev_ipsec, &rd)) {
	    do_dev_ipsec_read(dev_ipsec);
	    count -= 1;
	}
	if (!count)
	    continue;
	for (i = 0; i < n_udp; i++) {
	    if (FD_ISSET(udp_ports[i], &rd)) {
		udp_read(udp_ports[i]);
	    }
	}
    }
}

int
main(int argc, char **argv)
{
    int dev_ipsec, pfkey;

    if (bind_ports() < 0)
	return 1;
    if (n_udp == 0)
	return 1;
    pfkey = socket(PF_KEY, SOCK_RAW, PF_KEY);
    if (pfkey < 0) 
    {
	perror("pfkey open");
	return 1;
    }
    dev_ipsec = open("/dev/ipsec", O_RDWR);
    if (dev_ipsec < 0) 
    {
	perror("/dev/ipsec open");
	return 1;
    }
    /* FIXME: more config files... */
    return 0;
}
