/* queue.h
 *
 * $Id: queue.h,v 1.1 1999/03/07 23:30:19 nisse Exp $
 *
 * Generic doubly linked list. */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1998 Niels Mller
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LSH_QUEUE_H_INCLUDED
#define LSH_QUEUE_H_INCLUDED

#include "lsh.h"

/* Layout taken from AmigaOS lists... The first node uses a prev
 * pointer that points to the queue's HEAD. The last node uses a next
 * pointer that points to the queue's TAIL field. The TAIL field is
 * always NULL; TAILPREV points to the last node in the queue. */
struct lsh_queue_node
{
  struct lsh_queue_node *np_links[2];
};
#define LSH_QUEUE_NEXT 0
#define LSH_QUEUE_PREV 1

struct lsh_queue
{
  struct lsh_queue_node *ht_links[3];
};
#define LSH_QUEUE_HEAD 0
#define LSH_QUEUE_TAIL 1
#define LSH_QUEUE_TAILPREV 2

/* This macro must be used at the start of a block, to make the
 * declarations legal. It is allowed to free n inside the loop. */

#define FOR_QUEUE(q, type, n)					\
  struct lsh_queue_node *n##_this, *n##_next;			\
  type n;							\
  for ( n##_this = (q)->ht_links[LSH_QUEUE_HEAD];		\
	( n = (type) n##_this,					\
	  (n##_next = n##_this->np_links[LSH_QUEUE_NEXT]));	\
	n_this = n_next)

void lsh_queue_init(struct lsh_queue *q);
int lsh_queue_is_empty(struct lsh_queue *q);
void lsh_queue_add_head(struct lsh_queue *q, struct lsh_queue_node *n);
void lsh_queue_add_tail(struct lsh_queue *q, struct lsh_queue_node *n);
void lsh_queue_remove(struct lsh_queue_node *n);
struct lsh_queue_node *lsh_queue_remove_head(struct lsh_queue *q);
struct lsh_queue_node *lsh_queue_remove_tail(struct lsh_queue *q);

#endif /* LSH_QUEUE_H_INCLUDED */
