#ifndef CLASS_DEFINE
struct string_handler
{
  struct lsh_object super;
  int (*(handler))(struct string_handler *self, struct lsh_string *s);
};
extern struct lsh_class string_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class string_handler_class =
{ STATIC_HEADER,
  0, "string_handler", sizeof(struct string_handler),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse
{
  struct scanner super;
  struct scanner *next;
};
extern struct lsh_class parse_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse *i = (struct parse *) o;
  mark((struct lsh_object *) i->next);
}

struct lsh_class parse_class =
{ STATIC_HEADER,
  &scanner_class, "parse", sizeof(struct parse),
  do_parse_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_string
{
  struct parse super;
  struct string_handler *handler;
};
extern struct lsh_class parse_string_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_string_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_string *i = (struct parse_string *) o;
  mark((struct lsh_object *) i->handler);
}

struct lsh_class parse_string_class =
{ STATIC_HEADER,
  &parse_class, "parse_string", sizeof(struct parse_string),
  do_parse_string_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_sexp
{
  struct parse super;
  struct sexp_handler *handler;
};
extern struct lsh_class parse_sexp_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_sexp_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_sexp *i = (struct parse_sexp *) o;
  mark((struct lsh_object *) i->handler);
}

struct lsh_class parse_sexp_class =
{ STATIC_HEADER,
  &parse_class, "parse_sexp", sizeof(struct parse_sexp),
  do_parse_sexp_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_literal_data
{
  struct parse_string super;
  UINT32 i;
  struct lsh_string *data;
};
extern struct lsh_class parse_literal_data_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_literal_data_free(struct lsh_object *o)
{
  struct parse_literal_data *i = (struct parse_literal_data *) o;
  lsh_string_free(i->data);
}

struct lsh_class parse_literal_data_class =
{ STATIC_HEADER,
  &parse_string_class, "parse_literal_data", sizeof(struct parse_literal_data),
  NULL,
  do_parse_literal_data_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_literal
{
  struct parse_string super;
  int got_length;
  UINT32 length;
};
extern struct lsh_class parse_literal_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class parse_literal_class =
{ STATIC_HEADER,
  &parse_string_class, "parse_literal", sizeof(struct parse_literal),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct return_string
{
  struct string_handler super;
  struct sexp_handler *c;
};
extern struct lsh_class return_string_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_return_string_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct return_string *i = (struct return_string *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class return_string_class =
{ STATIC_HEADER,
  &string_handler_class, "return_string", sizeof(struct return_string),
  do_return_string_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_skip
{
  struct parse_sexp super;
  int expect;
  struct sexp *value;
};
extern struct lsh_class parse_skip_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_skip_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_skip *i = (struct parse_skip *) o;
  mark((struct lsh_object *) i->value);
}

struct lsh_class parse_skip_class =
{ STATIC_HEADER,
  &parse_sexp_class, "parse_skip", sizeof(struct parse_skip),
  do_parse_skip_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct handle_display
{
  struct string_handler super;
  struct lsh_string *display;
  struct sexp_handler *c;
};
extern struct lsh_class handle_display_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_handle_display_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct handle_display *i = (struct handle_display *) o;
  mark((struct lsh_object *) i->c);
}

static void do_handle_display_free(struct lsh_object *o)
{
  struct handle_display *i = (struct handle_display *) o;
  lsh_string_free(i->display);
}

struct lsh_class handle_display_class =
{ STATIC_HEADER,
  &string_handler_class, "handle_display", sizeof(struct handle_display),
  do_handle_display_mark,
  do_handle_display_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct handle_element
{
  struct sexp_handler super;
  unsigned count;
  struct parse_node * tail;
};
extern struct lsh_class handle_element_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_handle_element_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct handle_element *i = (struct handle_element *) o;
  do_mark_parse_node(i->tail, mark);
}

static void do_handle_element_free(struct lsh_object *o)
{
  struct handle_element *i = (struct handle_element *) o;
  do_free_parse_node(i->tail);
}

struct lsh_class handle_element_class =
{ STATIC_HEADER,
  &sexp_handler_class, "handle_element", sizeof(struct handle_element),
  do_handle_element_mark,
  do_handle_element_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct parse_list
{
  struct parse_sexp super;
  struct handle_element *elements;
  int advanced;
  struct scanner *start;
};
extern struct lsh_class parse_list_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_parse_list_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_list *i = (struct parse_list *) o;
  mark((struct lsh_object *) i->elements);
  mark((struct lsh_object *) i->start);
}

struct lsh_class parse_list_class =
{ STATIC_HEADER,
  &parse_sexp_class, "parse_list", sizeof(struct parse_list),
  do_parse_list_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct decode_base64
{
  struct parse super;
  struct base64_state state;
  struct scanner *contents;
};
extern struct lsh_class decode_base64_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_decode_base64_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct decode_base64 *i = (struct decode_base64 *) o;
  mark((struct lsh_object *) i->contents);
}

struct lsh_class decode_base64_class =
{ STATIC_HEADER,
  &parse_class, "decode_base64", sizeof(struct decode_base64),
  do_decode_base64_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

