/* lshd.c
 *
 * main server program.
 */

#include <stdio.h>
#include <locale.h>

#include "getopt.h"

#include "io.h"
#include "werror.h"
#include "server.h"

#define BLOCK_SIZE 32768

/* Global variable */
struct io_backend backend;

void usage() NORETURN;

void usage()
{
  exit(1);
}

int main(int argc, char **argv)
{
  char *host = NULL;  /* Interface to bind */
  char *port = "ssh";
  int option;

  struct sockaddr_in local;
    
  /* For filtering messages. Could perhaps also be used when converting
   * strings to and from UTF8. */
  setlocale(LC_CTYPE, "");
  
  while((option = getopt(argc, argv, "dp:qi:v")) != -1)
    switch(option)
      {
      case 'p':
	port = optarg;
	break;
      case 'q':
	quiet_flag = 1;
	break;
      case 'd':
	debug_flag = 1;
	break;
      case 'i':
	host = optarg;
	break;
      case 'v':
	verbose_flag = 1;
	break;
      default:
	usage();
      }

  if ( (argc - optind) != 0)
    usage();

  if (!get_inaddr(&local, host, port, "tcp"))
    {
      fprintf(stderr, "No such host or service");
      exit(1);
    }

  io_listen(&backend, &local, 
	    make_server_callback(&backend,
				 "lsh - a free ssh",
				 BLOCK_SIZE));
  
  io_run(&backend);

  return 0;
}
