#ifndef CLASS_DEFINE
struct sexp_string
{
  struct sexp super;
  struct lsh_string *display;
  struct lsh_string *contents;
};
extern struct lsh_class sexp_string_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_sexp_string_free(struct lsh_object *o)
{
  struct sexp_string *i = (struct sexp_string *) o;
  lsh_string_free(i->display);
  lsh_string_free(i->contents);
}

struct lsh_class sexp_string_class =
{ STATIC_HEADER,
  &sexp_class, "sexp_string", sizeof(struct sexp_string),
  NULL,
  do_sexp_string_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct sexp_vector
{
  struct sexp super;
  struct object_list *elements;
};
extern struct lsh_class sexp_vector_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_sexp_vector_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct sexp_vector *i = (struct sexp_vector *) o;
  mark((struct lsh_object *) i->elements);
}

struct lsh_class sexp_vector_class =
{ STATIC_HEADER,
  &sexp_class, "sexp_vector", sizeof(struct sexp_vector),
  do_sexp_vector_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

