/* spki.c
 *
 * An implementation of SPKI certificate checking
 *
 * $Id$ */

/* lsh, an implementation of the ssh protocol
 *
 * Copyright (C) 1999 Balazs Scheidler
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "spki.h"
#include "parse.h"
#include "sexp.h"
#include "xalloc.h"
#include "publickey_crypto.h"
#include "werror.h"

struct sexp *keyblob2spki(struct lsh_string *keyblob)
{
  struct simple_buffer buffer;
  struct dsa_public dsa;
  UINT32 kbtype;

  simple_buffer_init(&buffer, keyblob->length, keyblob->data);
  if (parse_atom(&buffer, &kbtype) &&
      (kbtype == ATOM_SSH_DSS) &&
      parse_dsa_public(&buffer, &dsa))
    {
      return sexp_l(2, sexp_z("public-key"),
		    sexp_l(5, sexp_z("dsa"),
			   sexp_l(2, sexp_z("p"), sexp_un(dsa.p), -1),
			   sexp_l(2, sexp_z("q"), sexp_un(dsa.q), -1),
			   sexp_l(2, sexp_z("g"), sexp_un(dsa.g), -1),
			   sexp_l(2, sexp_z("y"), sexp_un(dsa.y), -1),
			   -1),
		    -1);
    }
  else
    {
      werror("Unknown keyblob format, only ssh-dss is supported\n");
      return NULL;
    }
}
