#ifndef GABA_DEFINE
struct sexp
{
  struct lsh_object super;
  struct sexp_iterator * (*(iter))(struct sexp *self);
  struct lsh_string * (*(format))(struct sexp *self, int style, unsigned indent);
};
extern struct lsh_class sexp_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class sexp_class =
{ STATIC_HEADER,
  0, "sexp", sizeof(struct sexp),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct sexp_cons
{
  struct sexp super;
  struct sexp *car;
  struct sexp_cons *cdr;
};
extern struct lsh_class sexp_cons_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_sexp_cons_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct sexp_cons *i = (struct sexp_cons *) o;
  mark((struct lsh_object *) i->car);
  mark((struct lsh_object *) i->cdr);
}

struct lsh_class sexp_cons_class =
{ STATIC_HEADER,
  &sexp_class, "sexp_cons", sizeof(struct sexp_cons),
  do_sexp_cons_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct sexp_iterator
{
  struct lsh_object super;
  struct sexp * (*(get))(struct sexp_iterator *self);
  void (*(set))(struct sexp_iterator *self, struct sexp *);
  void (*(next))(struct sexp_iterator *self);
};
extern struct lsh_class sexp_iterator_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class sexp_iterator_class =
{ STATIC_HEADER,
  0, "sexp_iterator", sizeof(struct sexp_iterator),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct sexp_handler
{
  struct lsh_object super;
  int (*(handler))(struct sexp_handler *self, struct sexp *e);
};
extern struct lsh_class sexp_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class sexp_handler_class =
{ STATIC_HEADER,
  0, "sexp_handler", sizeof(struct sexp_handler),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

