#ifndef GABA_DEFINE
struct client_userauth
{
  struct command super;
  struct lsh_string *username;
  int service_name;
};
extern struct lsh_class client_userauth_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_client_userauth_free(struct lsh_object *o)
{
  struct client_userauth *i = (struct client_userauth *) o;
  lsh_string_free(i->username);
}

struct lsh_class client_userauth_class =
{ STATIC_HEADER,
  &command_class, "client_userauth", sizeof(struct client_userauth),
  NULL,
  do_client_userauth_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct success_handler
{
  struct packet_handler super;
  struct command_continuation *c;
};
extern struct lsh_class success_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_success_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct success_handler *i = (struct success_handler *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class success_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "success_handler", sizeof(struct success_handler),
  do_success_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct failure_handler
{
  struct packet_handler super;
  struct exception_handler *e;
  struct client_userauth *userauth;
};
extern struct lsh_class failure_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_failure_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct failure_handler *i = (struct failure_handler *) o;
  mark((struct lsh_object *) i->e);
  mark((struct lsh_object *) i->userauth);
}

struct lsh_class failure_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "failure_handler", sizeof(struct failure_handler),
  do_failure_handler_mark,
  NULL
};
#endif /* !GABA_DECLARE */

