#ifndef GABA_DEFINE
struct fd_callback
{
  struct lsh_object super;
  void (*(f))(struct fd_callback **self, int fd);
};
extern struct lsh_class fd_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class fd_callback_class =
{ STATIC_HEADER,
  0, "fd_callback", sizeof(struct fd_callback),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct close_callback
{
  struct lsh_object super;
  int (*(f))(struct close_callback *self, int reason);
};
extern struct lsh_class close_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class close_callback_class =
{ STATIC_HEADER,
  0, "close_callback", sizeof(struct close_callback),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_read_callback
{
  struct lsh_object super;
  void (*(read))(struct io_read_callback *self, struct lsh_fd *fd);
};
extern struct lsh_class io_read_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class io_read_callback_class =
{ STATIC_HEADER,
  0, "io_read_callback", sizeof(struct io_read_callback),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct lsh_fd
{
  struct resource super;
  struct lsh_fd *next;
  int fd;
  struct exception_handler *e;
  int close_reason;
  struct close_callback *close_callback;
  void (*(prepare))(struct lsh_fd *self);
  int want_read;
  struct io_read_callback *read;
  int want_write;
  void (*(write))(struct lsh_fd *self);
  void (*(really_close))(struct lsh_fd *self);
};
extern struct lsh_class lsh_fd_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_lsh_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct lsh_fd *i = (struct lsh_fd *) o;
  mark((struct lsh_object *) i->next);
  mark((struct lsh_object *) i->e);
  mark((struct lsh_object *) i->close_callback);
  mark((struct lsh_object *) i->read);
}

struct lsh_class lsh_fd_class =
{ STATIC_HEADER,
  &resource_class, "lsh_fd", sizeof(struct lsh_fd),
  do_lsh_fd_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_fd
{
  struct lsh_fd super;
  struct write_buffer *write_buffer;
};
extern struct lsh_class io_fd_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_fd *i = (struct io_fd *) o;
  mark((struct lsh_object *) i->write_buffer);
}

struct lsh_class io_fd_class =
{ STATIC_HEADER,
  &lsh_fd_class, "io_fd", sizeof(struct io_fd),
  do_io_fd_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_buffered_read
{
  struct io_read_callback super;
  UINT32 buffer_size;
  struct read_handler *handler;
};
extern struct lsh_class io_buffered_read_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_buffered_read_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_buffered_read *i = (struct io_buffered_read *) o;
  mark((struct lsh_object *) i->handler);
}

struct lsh_class io_buffered_read_class =
{ STATIC_HEADER,
  &io_read_callback_class, "io_buffered_read", sizeof(struct io_buffered_read),
  do_io_buffered_read_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_consuming_read
{
  struct io_read_callback super;
  UINT32 (*(query))(struct io_consuming_read *self);
  struct abstract_write *consumer;
};
extern struct lsh_class io_consuming_read_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_consuming_read_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_consuming_read *i = (struct io_consuming_read *) o;
  mark((struct lsh_object *) i->consumer);
}

struct lsh_class io_consuming_read_class =
{ STATIC_HEADER,
  &io_read_callback_class, "io_consuming_read", sizeof(struct io_consuming_read),
  do_io_consuming_read_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct address_info
{
  struct lsh_object super;
  struct lsh_string *ip;
  UINT32 port;
};
extern struct lsh_class address_info_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_address_info_free(struct lsh_object *o)
{
  struct address_info *i = (struct address_info *) o;
  lsh_string_free(i->ip);
}

struct lsh_class address_info_class =
{ STATIC_HEADER,
  0, "address_info", sizeof(struct address_info),
  NULL,
  do_address_info_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct fd_listen_callback
{
  struct lsh_object super;
  void (*(f))(struct fd_listen_callback *self, int, struct address_info *);
};
extern struct lsh_class fd_listen_callback_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class fd_listen_callback_class =
{ STATIC_HEADER,
  0, "fd_listen_callback", sizeof(struct fd_listen_callback),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct listen_fd
{
  struct lsh_fd super;
  struct fd_listen_callback *callback;
};
extern struct lsh_class listen_fd_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_listen_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_fd *i = (struct listen_fd *) o;
  mark((struct lsh_object *) i->callback);
}

struct lsh_class listen_fd_class =
{ STATIC_HEADER,
  &lsh_fd_class, "listen_fd", sizeof(struct listen_fd),
  do_listen_fd_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct connect_fd
{
  struct lsh_fd super;
  struct fd_callback *callback;
};
extern struct lsh_class connect_fd_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_connect_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct connect_fd *i = (struct connect_fd *) o;
  mark((struct lsh_object *) i->callback);
}

struct lsh_class connect_fd_class =
{ STATIC_HEADER,
  &lsh_fd_class, "connect_fd", sizeof(struct connect_fd),
  do_connect_fd_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_backend
{
  struct lsh_object super;
  struct lsh_fd *files;
};
extern struct lsh_class io_backend_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_backend_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_backend *i = (struct io_backend *) o;
  mark((struct lsh_object *) i->files);
}

struct lsh_class io_backend_class =
{ STATIC_HEADER,
  0, "io_backend", sizeof(struct io_backend),
  do_io_backend_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct io_exception
{
  struct exception super;
  struct lsh_fd *fd;
  int error;
};
extern struct lsh_class io_exception_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_io_exception_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_exception *i = (struct io_exception *) o;
  mark((struct lsh_object *) i->fd);
}

struct lsh_class io_exception_class =
{ STATIC_HEADER,
  &exception_class, "io_exception", sizeof(struct io_exception),
  do_io_exception_mark,
  NULL
};
#endif /* !GABA_DECLARE */

