#ifndef GABA_DEFINE
struct unix_user
{
  struct lsh_object super;
  uid_t uid;
  gid_t gid;
  struct lsh_string *name;
  struct lsh_string *passwd;
  struct lsh_string *home;
  struct lsh_string *shell;
};
extern struct lsh_class unix_user_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_unix_user_free(struct lsh_object *o)
{
  struct unix_user *i = (struct unix_user *) o;
  lsh_string_free(i->name);
  lsh_string_free(i->passwd);
  lsh_string_free(i->home);
  lsh_string_free(i->shell);
}

struct lsh_class unix_user_class =
{ STATIC_HEADER,
  0, "unix_user", sizeof(struct unix_user),
  NULL,
  do_unix_user_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct user_db
{
  struct lsh_object super;
  struct unix_user * (*(lookup))(struct user_db *self, struct lsh_string *name, int free);
};
extern struct lsh_class user_db_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class user_db_class =
{ STATIC_HEADER,
  0, "user_db", sizeof(struct user_db),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

