/* 
 * memmove for systems that doesn't have it 
 *
 * $Id: memmove.c,v 1.1 1995/07/20 16:56:56 d91-jda Exp $
 *
 */

#include <config.h>

#ifndef HAVE_MEMMOVE

#include <sys/types.h>

void* memmove(void *s1, const void *s2, size_t n)
{
  char *s=(char*)s2, *d=(char*)s1;

  if(d > s){
    s+=n-1;
    d+=n-1;
    while(n){
      *d--=*s--;
      n--;
    }
  }else if(d < s)
    while(n){
      *d++=*s++;
      n--;
    }
  return s1;
}

#endif
