/* ctelnet.c - Simple telnet client with encryption */

/* Known Bugs: Only does remote echo */

#include <stdio.h>
#include <netdb.h>
#include <sys/file.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <errno.h>
#ifdef SUNOS
#include <sys/termios.h>
#include <sys/filio.h>
#include <fcntl.h>
#endif
#ifdef LINUX
#include <sys/ioctl.h>
#include <sys/time.h>
#endif
#ifdef ULTRIX
#include <sys/ioctl.h>
#include <sys/termios.h>
#endif

void main(int argc,char **argv)
{
  register char *p;
  register char *dest;
  register int x;
  char hostname[256];
  int addr,port;
  int connection_ok;
  struct hostent *host;
  int fd,remotefd;
  struct sockaddr_in remoteserver;
  unsigned char c;
  fd_set readfds;
  fd_set writefds;
  fd_set exceptfds;
  struct termios tiostr;
  int r=1;
  int w=1;
  char buffer[1024];
  char buffer2[1024];
  int o,a,b;
  unsigned char iac_flag=0,iac_wwdd,iac_command;
  char key[1024];
  int error=0;
   
  unsigned char (*ks1)[8];
  unsigned char (*ks2)[8];
  unsigned char (*ks3)[8];
  static unsigned char inc1[8];
  static unsigned char inc2[8];
  static unsigned char inc3[8];
  static unsigned char iv0a[8];
  static unsigned char iv1a[8];
  static unsigned char iv2a[8];
  static unsigned char iv3a[8];
  static unsigned char iv0b[8];
  static unsigned char iv1b[8];
  static unsigned char iv2b[8];
  static unsigned char iv3b[8];
  char bytecount[2]={0,0};
  
  if (argc<=2) {
    printf("Usage: %s hostname port [telnet-port]\n",argv[0]);
    exit(0);
  }
  strcpy(hostname,argv[1]);
  host = gethostbyname (hostname);
  if (!host) {
    printf("%s: unknown host\n", hostname);
    exit(1);
  }
  bcopy (host->h_addr, &addr, 4);
  remoteserver.sin_family = host->h_addrtype;
  remoteserver.sin_port = htons(atoi(argv[2]));
  
  p = (char *)*(host->h_addr_list);
  for (dest = (char *)&remoteserver.sin_addr, x = host->h_length; --x >= 0; )
    *dest++ = *p++;

  printf("Trying...\n");
  
  remotefd = socket(host->h_addrtype, SOCK_STREAM, 0);

  connection_ok = connect (remotefd, (struct sockaddr *)&remoteserver, sizeof(remoteserver));

  if (connection_ok < 0)
    {
      printf ("Connection failed\n");
      fflush (stdout);
      exit(1);
    }

  /* Okay, connection established. */

  printf ("Connected.\n");
  printf ("Doing Diffie-Hellman key exchange..");fflush(stdout);
  do_dh(remotefd,key);

  ks1 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);
  ks2 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);
  ks3 = (unsigned char (*)[8])malloc(sizeof(char) * 8 * 16);
  desinit(1);
  setkey(key+1000,ks1);
  setkey(key+1008,ks2);
  setkey(key+1016,ks3);
  bcopy(key+976,inc1,8);
  bcopy(key+984,inc2,8);
  bcopy(key+992,inc3,8);
  bcopy(key+968,iv0a,8);bcopy(key+968,iv0b,8);
  bcopy(key+960,iv1a,8);bcopy(key+960,iv1b,8);
  bcopy(key+952,iv2a,8);bcopy(key+952,iv2b,8);
  bcopy(key+944,iv3a,8);bcopy(key+944,iv3b,8);
  bzero(key,1024);

  strcpy(buffer,"encr\n");
  write(remotefd,buffer,5);
  read(remotefd,buffer,4);
  if(strncmp(buffer,"2300",4)) {
    printf("Encryption Error\n");
    exit(1);
  }
  printf ("Done\n");
  
  while(*buffer!=10) read(remotefd,buffer,1);
  *buffer=0;
  while(*buffer!=10) {
    read(remotefd,buffer,1);
    bytecount[1]&=7;
    if (bytecount[1]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
    }
    buffer[0]^=iv0b[bytecount[1]++];
  }

  if (argc>3) port=atoi(argv[3]);
    else port=23;
  sprintf(buffer,"lport %x\n",port);

  for(a=0;buffer[a]!=0;a++) {
    bytecount[0]&=7;
    if (bytecount[0]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0a,iv1a,iv2a,iv3a,inc1,inc2,inc3);
    }
    buffer[a]^=iv0a[bytecount[0]++];
  }
  write(remotefd,buffer,a);
  
  read(remotefd,buffer,4);
  for(a=0;a<4;a++){
    bytecount[1]&=7;
    if (bytecount[1]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
    }
    buffer[a]^=iv0b[bytecount[1]++];
  }
  buffer[4]=0;
  if (strcmp(buffer,"2500")) {
    printf("Error %s",buffer);
    error=1;
  }
  while(*buffer!=10) {
    read(remotefd,buffer,1);
    bytecount[1]&=7;
    if (bytecount[1]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
    }
    buffer[0]^=iv0b[bytecount[1]++];
    if(error) putchar(*buffer); 
  }
  if(error){putchar('\n');exit(1);}

  read(remotefd,buffer,4);
  for(a=0;a<4;a++){
    bytecount[1]&=7;
    if (bytecount[1]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
    }
    buffer[a]^=iv0b[bytecount[1]++];
  }
  buffer[4]=0;
  if (strcmp(buffer,"2400")) {
    printf("Error %s",buffer);
    error=1;
  }
  while(*buffer!=10) {
    read(remotefd,buffer,1);
    bytecount[1]&=7;
    if (bytecount[1]==0) {
      do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
    }
    buffer[0]^=iv0b[bytecount[1]++];
    if(error) putchar(*buffer); 
  }
  if(error){putchar('\n');exit(1);}
  
  printf("Encrypted session established.\n");
    
  fcntl(remotefd, O_NDELAY);
  fd=0;
  fcntl(fd, O_NDELAY);

  a=1;
  ioctl(fd, FIONBIO, &a); /* Non-Blocking I/O */
  ioctl(remotefd, FIONBIO, &a);
  ioctl(fd, FIOASYNC, &a);
  ioctl(remotefd, FIOASYNC, &a);

#ifdef ULTRIX
  ioctl(fd, TCGETA, &tiostr);
#else
  ioctl(fd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
  tiostr.c_cc[VINTR]=0;
  tiostr.c_cc[VQUIT]=0;
  tiostr.c_cc[VEOF]=0;
#ifdef ULTRIX
  ioctl(fd, TCSETA, &tiostr);
#else
  ioctl(fd, TCSETS, &tiostr);
#endif

#ifdef ULTRIX
  ioctl(remotefd, TCGETA, &tiostr);
#else
  ioctl(remotefd, TCGETS, &tiostr);
#endif
  tiostr.c_lflag=0; /* Disable all processing; unaltered 8-bit channel */
  tiostr.c_iflag=0;
  tiostr.c_oflag=0;
#ifdef ULTRIX
  ioctl(remotefd, TCSETA, &tiostr);
#else
  ioctl(remotefd, TCSETS, &tiostr);
#endif

  while(r!=0&&w!=0) {
    FD_ZERO(&writefds);
    FD_ZERO(&exceptfds);
    FD_ZERO(&readfds);
    FD_SET(fd, &readfds);
    FD_SET(remotefd, &readfds);
    FD_SET(fd, &exceptfds);
    FD_SET(remotefd, &exceptfds);        
    select(16, &readfds, &writefds, &exceptfds,(struct timeval *)0);
    if(FD_ISSET(fd,&readfds)) {
      w=read(fd,buffer,1024);if (w>0)
      {
        for(a=0;a<w;a++) {
          bytecount[0]&=7;
          if (bytecount[0]==0) {
            do_tdes_block(ks1,ks2,ks3,iv0a,iv1a,iv2a,iv3a,inc1,inc2,inc3);
          }
          buffer[a]^=iv0a[bytecount[0]++];
        }
        o=0;
        while(o<w) o+=write(remotefd,buffer+o,w-o);
      }
    }
    if(FD_ISSET(remotefd,&readfds)) {
      r=read(remotefd,buffer,1024);if (r>0)
      {
        for(a=0;a<r;a++) {
          bytecount[1]&=7;
          if (bytecount[1]==0) {
            do_tdes_block(ks1,ks2,ks3,iv0b,iv1b,iv2b,iv3b,inc1,inc2,inc3);
          }
          buffer[a]^=iv0b[bytecount[1]++];
        }
        o=0;b=0;
        while(o<r)
        {
          if(iac_flag==0) {
            if ((unsigned char)buffer[o]!=255){
              printf("%c",buffer[o]);
            }else iac_flag++;
          }else if(iac_flag==1){
            iac_wwdd=(unsigned char)buffer[o];
            iac_flag++;
          }else if(iac_flag==2){
            if(iac_wwdd==253) /* DO */
            {
              buffer2[b++]=255;
              if (buffer[o]==3) /* 3=Supress Go Ahead */
              {
                buffer2[b++]=251; /* Will */
              }else{
                buffer2[b++]=252; /* Wont */
              }
              buffer2[b++]=buffer[o];
            }
            if(iac_wwdd==251) /* WILL */
            {
              buffer2[b++]=255;
              if (buffer[o]==1||buffer[o]==3) /* 1=Echo 3=SGA */
              {
                buffer2[b++]=253; /* Do */
              }else{
                buffer2[b++]=254; /* Dont */
              }
              buffer2[b++]=buffer[o];
            }
            iac_flag=0;
#ifdef DEBUG
            printf("IAC %d %d ",iac_wwdd,buffer[o]);
#endif
          }
          o++;
        }
        for(a=0;a<b;a++) {
          bytecount[0]&=7;
          if (bytecount[0]==0) {
            do_tdes_block(ks1,ks2,ks3,iv0a,iv1a,iv2a,iv3a,inc1,inc2,inc3);
          }
          buffer2[a]^=iv0a[bytecount[0]++];
        }
        o=0;while(o<b) o+=write(remotefd,buffer2+o,b-o);

        fflush(stdout);
      }
    }
  }

  close(remotefd);
  close(fd);

  free(ks1);free(ks2);free(ks3);
  desdone();
  
}
