#ifndef CLASS_DEFINE
struct dsa_signer
{
  struct signer super;
  struct randomness *random;
  struct dsa_public public;
  mpz_t a;
};
extern struct lsh_class dsa_signer_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dsa_signer_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  mark((struct lsh_object *) i->random);
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_signer_free(struct lsh_object *o)
{
  struct dsa_signer *i = (struct dsa_signer *) o;
  dsa_public_free(&i->public);
  mpz_clear(i->a);
}

struct lsh_class dsa_signer_class =
{ STATIC_HEADER,
  &signer_class, "dsa_signer", sizeof(struct dsa_signer),
  do_dsa_signer_mark,
  do_dsa_signer_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dsa_verifier
{
  struct verifier super;
  struct dsa_public public;
};
extern struct lsh_class dsa_verifier_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dsa_verifier_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_mark(&i->public, mark);
}

static void do_dsa_verifier_free(struct lsh_object *o)
{
  struct dsa_verifier *i = (struct dsa_verifier *) o;
  dsa_public_free(&i->public);
}

struct lsh_class dsa_verifier_class =
{ STATIC_HEADER,
  &verifier_class, "dsa_verifier", sizeof(struct dsa_verifier),
  do_dsa_verifier_mark,
  do_dsa_verifier_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct dsa_algorithm
{
  struct signature_algorithm super;
  struct randomness *random;
};
extern struct lsh_class dsa_algorithm_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_dsa_algorithm_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct dsa_algorithm *i = (struct dsa_algorithm *) o;
  mark((struct lsh_object *) i->random);
}

struct lsh_class dsa_algorithm_class =
{ STATIC_HEADER,
  &signature_algorithm_class, "dsa_algorithm", sizeof(struct dsa_algorithm),
  do_dsa_algorithm_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct group_zn
{
  struct group super;
  mpz_t modulo;
};
extern struct lsh_class group_zn_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_group_zn_free(struct lsh_object *o)
{
  struct group_zn *i = (struct group_zn *) o;
  mpz_clear(i->modulo);
}

struct lsh_class group_zn_class =
{ STATIC_HEADER,
  &group_class, "group_zn", sizeof(struct group_zn),
  NULL,
  do_group_zn_free
};
#endif /* !CLASS_DECLARE */

