#ifndef CLASS_DEFINE
struct kexinit_handler
{
  struct packet_handler super;
  int type;
  struct make_kexinit *init;
  struct alist *algorithms;
  struct ssh_service *finished;
};
extern struct lsh_class kexinit_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_kexinit_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct kexinit_handler *i = (struct kexinit_handler *) o;
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->finished);
}

struct lsh_class kexinit_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "kexinit_handler", sizeof(struct kexinit_handler),
  do_kexinit_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct newkeys_handler
{
  struct packet_handler super;
  struct crypto_instance *crypto;
  struct mac_instance *mac;
};
extern struct lsh_class newkeys_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_newkeys_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct newkeys_handler *i = (struct newkeys_handler *) o;
  mark((struct lsh_object *) i->crypto);
  mark((struct lsh_object *) i->mac);
}

struct lsh_class newkeys_handler_class =
{ STATIC_HEADER,
  &packet_handler_class, "newkeys_handler", sizeof(struct newkeys_handler),
  do_newkeys_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct simple_kexinit
{
  struct make_kexinit super;
  struct randomness *r;
  struct int_list *kex_algorithms;
  struct int_list *hostkey_algorithms;
  struct int_list *crypto_algorithms;
  struct int_list *mac_algorithms;
  struct int_list *compression_algorithms;
  struct int_list *languages;
};
extern struct lsh_class simple_kexinit_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_simple_kexinit_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct simple_kexinit *i = (struct simple_kexinit *) o;
  mark((struct lsh_object *) i->r);
  mark((struct lsh_object *) i->kex_algorithms);
  mark((struct lsh_object *) i->hostkey_algorithms);
  mark((struct lsh_object *) i->crypto_algorithms);
  mark((struct lsh_object *) i->mac_algorithms);
  mark((struct lsh_object *) i->compression_algorithms);
  mark((struct lsh_object *) i->languages);
}

struct lsh_class simple_kexinit_class =
{ STATIC_HEADER,
  &make_kexinit_class, "simple_kexinit", sizeof(struct simple_kexinit),
  do_simple_kexinit_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct install_new_keys
{
  struct install_keys super;
  int is_server;
  struct object_list *algorithms;
};
extern struct lsh_class install_new_keys_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_install_new_keys_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct install_new_keys *i = (struct install_new_keys *) o;
  mark((struct lsh_object *) i->algorithms);
}

struct lsh_class install_new_keys_class =
{ STATIC_HEADER,
  &install_keys_class, "install_new_keys", sizeof(struct install_new_keys),
  do_install_new_keys_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

