#ifndef CLASS_DEFINE
struct server_callback
{
  struct fd_callback super;
  struct io_backend *backend;
  struct signer *secret;
  struct lsh_string *host_key;
  UINT32 block_size;
  char * id_comment;
  struct randomness *random;
  struct make_kexinit *init;
  struct packet_handler *kexinit_handler;
};
extern struct lsh_class server_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_callback_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_callback *i = (struct server_callback *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->secret);
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->init);
  mark((struct lsh_object *) i->kexinit_handler);
}

static void do_server_callback_free(struct lsh_object *o)
{
  struct server_callback *i = (struct server_callback *) o;
  lsh_string_free(i->host_key);
}

struct lsh_class server_callback_class =
{ STATIC_HEADER,
  &fd_callback_class, "server_callback", sizeof(struct server_callback),
  do_server_callback_mark,
  do_server_callback_free
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_line_handler
{
  struct line_handler super;
  struct ssh_connection *connection;
};
extern struct lsh_class server_line_handler_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_line_handler_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_line_handler *i = (struct server_line_handler *) o;
  mark((struct lsh_object *) i->connection);
}

struct lsh_class server_line_handler_class =
{ STATIC_HEADER,
  &line_handler_class, "server_line_handler", sizeof(struct server_line_handler),
  do_server_line_handler_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_session
{
  struct ssh_channel super;
  struct unix_user *user;
  int running;
  struct io_fd *in;
  struct io_fd *out;
  struct io_fd *err;
};
extern struct lsh_class server_session_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_session *i = (struct server_session *) o;
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->in);
  mark((struct lsh_object *) i->out);
  mark((struct lsh_object *) i->err);
}

struct lsh_class server_session_class =
{ STATIC_HEADER,
  &ssh_channel_class, "server_session", sizeof(struct server_session),
  do_server_session_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct open_session
{
  struct channel_open super;
  struct unix_user *user;
  struct alist *session_requests;
};
extern struct lsh_class open_session_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_open_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct open_session *i = (struct open_session *) o;
  mark((struct lsh_object *) i->user);
  mark((struct lsh_object *) i->session_requests);
}

struct lsh_class open_session_class =
{ STATIC_HEADER,
  &channel_open_class, "open_session", sizeof(struct open_session),
  do_open_session_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct server_connection_service
{
  struct unix_service super;
  struct alist *global_requests;
  struct alist *session_requests;
};
extern struct lsh_class server_connection_service_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_server_connection_service_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct server_connection_service *i = (struct server_connection_service *) o;
  mark((struct lsh_object *) i->global_requests);
  mark((struct lsh_object *) i->session_requests);
}

struct lsh_class server_connection_service_class =
{ STATIC_HEADER,
  &unix_service_class, "server_connection_service", sizeof(struct server_connection_service),
  do_server_connection_service_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct exit_shell
{
  struct exit_callback super;
  struct server_session *session;
};
extern struct lsh_class exit_shell_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_exit_shell_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct exit_shell *i = (struct exit_shell *) o;
  mark((struct lsh_object *) i->session);
}

struct lsh_class exit_shell_class =
{ STATIC_HEADER,
  &exit_callback_class, "exit_shell", sizeof(struct exit_shell),
  do_exit_shell_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct shell_request
{
  struct channel_request super;
  struct io_backend *backend;
  struct reap *reap;
};
extern struct lsh_class shell_request_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_shell_request_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct shell_request *i = (struct shell_request *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->reap);
}

struct lsh_class shell_request_class =
{ STATIC_HEADER,
  &channel_request_class, "shell_request", sizeof(struct shell_request),
  do_shell_request_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

