#ifndef CLASS_DEFINE
struct fd_callback
{
  struct lsh_object super;
  int (*(f))(struct fd_callback **self, int fd);
};
extern struct lsh_class fd_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class fd_callback_class =
{ STATIC_HEADER,
  0, "fd_callback", sizeof(struct fd_callback),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct close_callback
{
  struct lsh_object super;
  int (*(f))(struct close_callback *self, int reason);
};
extern struct lsh_class close_callback_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class close_callback_class =
{ STATIC_HEADER,
  0, "close_callback", sizeof(struct close_callback),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct lsh_fd
{
  struct lsh_object super;
  struct lsh_fd *next;
  int fd;
  int close_reason;
  struct close_callback *close_callback;
  void (*(prepare))(struct lsh_fd *self);
  int want_read;
  void (*(read))(struct lsh_fd *self);
  int want_write;
  void (*(write))(struct lsh_fd *self);
  int close_now;
  void (*(really_close))(struct lsh_fd *self);
};
extern struct lsh_class lsh_fd_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_lsh_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct lsh_fd *i = (struct lsh_fd *) o;
  mark((struct lsh_object *) i->next);
  mark((struct lsh_object *) i->close_callback);
}

struct lsh_class lsh_fd_class =
{ STATIC_HEADER,
  0, "lsh_fd", sizeof(struct lsh_fd),
  do_lsh_fd_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct io_fd
{
  struct lsh_fd super;
  struct read_handler *handler;
  struct write_buffer *buffer;
};
extern struct lsh_class io_fd_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_io_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_fd *i = (struct io_fd *) o;
  mark((struct lsh_object *) i->handler);
  mark((struct lsh_object *) i->buffer);
}

struct lsh_class io_fd_class =
{ STATIC_HEADER,
  &lsh_fd_class, "io_fd", sizeof(struct io_fd),
  do_io_fd_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct listen_fd
{
  struct lsh_fd super;
  struct fd_callback *callback;
};
extern struct lsh_class listen_fd_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_listen_fd_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct listen_fd *i = (struct listen_fd *) o;
  mark((struct lsh_object *) i->callback);
}

struct lsh_class listen_fd_class =
{ STATIC_HEADER,
  &lsh_fd_class, "listen_fd", sizeof(struct listen_fd),
  do_listen_fd_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct io_backend
{
  struct lsh_object super;
  struct lsh_fd *files;
};
extern struct lsh_class io_backend_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_io_backend_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct io_backend *i = (struct io_backend *) o;
  mark((struct lsh_object *) i->files);
}

struct lsh_class io_backend_class =
{ STATIC_HEADER,
  0, "io_backend", sizeof(struct io_backend),
  do_io_backend_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

