#ifndef CLASS_DEFINE
struct ssh_channel
{
  struct lsh_object super;
  UINT32 channel_number;
  UINT32 max_window;
  UINT32 rec_window_size;
  UINT32 rec_max_packet;
  UINT32 send_window_size;
  UINT32 send_max_packet;
  struct abstract_write *write;
  struct alist *request_types;
  int flags;
  int sources;
  int (*(recieve))(struct ssh_channel *self, int type, struct lsh_string *data);
  int (*(send))(struct ssh_channel *self);
  void (*(close))(struct ssh_channel *self);
  int (*(eof))(struct ssh_channel *self);
  int (*(open_confirm))(struct ssh_channel *self);
  int (*(open_failure))(struct ssh_channel *self);
  int (*(channel_success))(struct ssh_channel *self);
  int (*(channel_failure))(struct ssh_channel *self);
};
extern struct lsh_class ssh_channel_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_ssh_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct ssh_channel *i = (struct ssh_channel *) o;
  mark((struct lsh_object *) i->write);
  mark((struct lsh_object *) i->request_types);
}

struct lsh_class ssh_channel_class =
{ STATIC_HEADER,
  0, "ssh_channel", sizeof(struct ssh_channel),
  do_ssh_channel_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_table
{
  struct lsh_object super;
  struct ssh_channel *(*(channels));
  UINT32 allocated_channels;
  UINT32 next_channel;
  UINT32 used_channels;
  UINT32 max_channels;
  int pending_close;
};
extern struct lsh_class channel_table_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
static void do_channel_table_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct channel_table *i = (struct channel_table *) o;
  {
  unsigned k;
  for (k=0; k<i->used_channels; k++)
    mark((struct lsh_object *) (i->channels)[k]);
}
}

struct lsh_class channel_table_class =
{ STATIC_HEADER,
  0, "channel_table", sizeof(struct channel_table),
  do_channel_table_mark,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct global_request
{
  struct lsh_object super;
  int (*(handler))(struct global_request *self, int want_reply, struct simple_buffer *args);
};
extern struct lsh_class global_request_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class global_request_class =
{ STATIC_HEADER,
  0, "global_request", sizeof(struct global_request),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_open
{
  struct lsh_object super;
  struct ssh_channel *(*(handler))(struct channel_open *self, struct simple_buffer *args, UINT32 *error, char **error_msg, struct lsh_string **data);
};
extern struct lsh_class channel_open_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class channel_open_class =
{ STATIC_HEADER,
  0, "channel_open", sizeof(struct channel_open),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct channel_request
{
  struct lsh_object super;
  int (*(handler))(struct channel_request *self, struct ssh_channel *channel, int want_reply, struct simple_buffer *args);
};
extern struct lsh_class channel_request_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class channel_request_class =
{ STATIC_HEADER,
  0, "channel_request", sizeof(struct channel_request),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

#ifndef CLASS_DEFINE
struct connection_startup
{
  struct lsh_object super;
  int (*(start))(struct connection_startup *self, struct channel_table *table, struct abstract_write *write);
};
extern struct lsh_class connection_startup_class;
#endif /* !CLASS_DEFINE */

#ifndef CLASS_DECLARE
struct lsh_class connection_startup_class =
{ STATIC_HEADER,
  0, "connection_startup", sizeof(struct connection_startup),
  NULL,
  NULL
};
#endif /* !CLASS_DECLARE */

