#ifndef GABA_DEFINE
struct proxy_channel
{
  struct ssh_channel super;
  struct proxy_channel *chain;
};
extern struct lsh_class proxy_channel_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_channel_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_channel *i = (struct proxy_channel *) o;
  mark((struct lsh_object *) i->chain);
}

struct lsh_class proxy_channel_class =
{ STATIC_HEADER,
  &ssh_channel_class, "proxy_channel", sizeof(struct proxy_channel),
  do_proxy_channel_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct proxy_open_session
{
  struct channel_open super;
  struct alist *session_requests;
};
extern struct lsh_class proxy_open_session_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_proxy_open_session_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct proxy_open_session *i = (struct proxy_open_session *) o;
  mark((struct lsh_object *) i->session_requests);
}

struct lsh_class proxy_open_session_class =
{ STATIC_HEADER,
  &channel_open_class, "proxy_open_session", sizeof(struct proxy_open_session),
  do_proxy_open_session_mark,
  NULL
};
#endif /* !GABA_DECLARE */

