#ifndef GABA_DEFINE
struct fake_host_db
{
  struct lookup_verifier super;
  struct signature_algorithm *algorithm;
};
extern struct lsh_class fake_host_db_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_fake_host_db_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct fake_host_db *i = (struct fake_host_db *) o;
  mark((struct lsh_object *) i->algorithm);
}

struct lsh_class fake_host_db_class =
{ STATIC_HEADER,
  &lookup_verifier_class, "fake_host_db", sizeof(struct fake_host_db),
  do_fake_host_db_mark,
  NULL
};
#endif /* !GABA_DECLARE */

static struct lsh_object *
make_client_connect(struct command *connect, struct command *handshake, struct command *userauth_service, struct command *login, struct object_list *requests)
{
  /* (B (progn requests) (B* init_connection login (B* userauth_service handshake connect))) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return MAKE_TRACE("make_client_connect", 
    B2(A(&progn_command.super.super, ((struct lsh_object *) requests)), Bp3(&connection_service.super, ((struct lsh_object *) login), Bp3(((struct lsh_object *) userauth_service), ((struct lsh_object *) handshake), ((struct lsh_object *) connect))))
  );
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
static struct lsh_object *
make_start_session(struct command *open_session, struct object_list *requests)
{
  /* (B (progn requests) open_session) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return MAKE_TRACE("make_start_session", 
    B2(A(&progn_command.super.super, ((struct lsh_object *) requests)), ((struct lsh_object *) open_session))
  );
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
static struct lsh_object *
start_shell(void)
{
  /* (B client_io request_shell) */
#define A GABA_APPLY
#define I GABA_VALUE_I
#define K GABA_VALUE_K
#define K1 GABA_APPLY_K_1
#define S GABA_VALUE_S
#define S1 GABA_APPLY_S_1
#define S2 GABA_APPLY_S_2
#define B GABA_VALUE_B
#define B1 GABA_APPLY_B_1
#define B2 GABA_APPLY_B_2
#define C GABA_VALUE_C
#define C1 GABA_APPLY_C_1
#define C2 GABA_APPLY_C_2
#define Sp GABA_VALUE_Sp
#define Sp1 GABA_APPLY_Sp_1
#define Sp2 GABA_APPLY_Sp_2
#define Sp3 GABA_APPLY_Sp_3
#define Bp GABA_VALUE_Bp
#define Bp1 GABA_APPLY_Bp_1
#define Bp2 GABA_APPLY_Bp_2
#define Bp3 GABA_APPLY_Bp_3
#define Cp GABA_VALUE_Cp
#define Cp1 GABA_APPLY_Cp_1
#define Cp2 GABA_APPLY_Cp_2
#define Cp3 GABA_APPLY_Cp_3
  return MAKE_TRACE("start_shell", 
    B2(&client_io.super, &request_shell.super.super)
  );
#undef A
#undef I
#undef K
#undef K1
#undef S
#undef S1
#undef S2
#undef B
#undef B1
#undef B2
#undef C
#undef C1
#undef C2
#undef Sp
#undef Sp1
#undef Sp2
#undef Sp3
#undef Bp
#undef Bp1
#undef Bp2
#undef Bp3
#undef Cp
#undef Cp1
#undef Cp2
#undef Cp3
}
#ifndef GABA_DEFINE
struct lsh_options
{
  struct algorithms_options super;
  struct io_backend *backend;
  struct randomness *random;
  struct exception_handler *handler;
  int * exit_code;
  int not;
  char * port;
  struct address_info *remote;
  char * user;
  struct object_queue identities;
  int publickey;
  int with_pty;
  int with_remote_peers;
  int start_shell;
  int remote_forward;
  struct object_queue actions;
};
extern struct lsh_class lsh_options_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_lsh_options_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct lsh_options *i = (struct lsh_options *) o;
  mark((struct lsh_object *) i->backend);
  mark((struct lsh_object *) i->random);
  mark((struct lsh_object *) i->handler);
  mark((struct lsh_object *) i->remote);
  object_queue_mark(&i->identities, mark);
  object_queue_mark(&i->actions, mark);
}

static void do_lsh_options_free(struct lsh_object *o)
{
  struct lsh_options *i = (struct lsh_options *) o;
  object_queue_free(&i->identities);
  object_queue_free(&i->actions);
}

struct lsh_class lsh_options_class =
{ STATIC_HEADER,
  &algorithms_options_class, "lsh_options", sizeof(struct lsh_options),
  do_lsh_options_mark,
  do_lsh_options_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct lsh_default_handler
{
  struct exception_handler super;
  int * status;
};
extern struct lsh_class lsh_default_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class lsh_default_handler_class =
{ STATIC_HEADER,
  &exception_handler_class, "lsh_default_handler", sizeof(struct lsh_default_handler),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

