/*
 * Copyright (c) 1997 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden). 
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 *
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 *
 * 3. All advertising materials mentioning features or use of this software 
 *    must display the following acknowledgement: 
 *      This product includes software developed by Kungliga Tekniska 
 *      Hgskolan and its contributors. 
 *
 * 4. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 */

#include "admin_locl.h"

RCSID("$Id: get.c,v 1.7 1997/08/15 21:56:46 assar Exp $");

int
get_entry(int argc, char **argv)
{
    HDB *db;
    int ret;
    hdb_entry ent;
    int i;
    
    if(argc != 2){
	fprintf(stderr, "Usage: get_entry principal\n");
	return 0;
    }
	
    krb5_parse_name(context, argv[1], &ent.principal);
    
    if((ret = hdb_open(context, &db, database, O_RDONLY, 0600))){
	fprintf(stderr, "hdb_open: %s\n", krb5_get_err_text(context, ret));
	return 0;
    }
    
    ret = db->fetch(context, db, &ent);
    
    switch(ret){
    case HDB_ERR_NOENTRY:
	fprintf(stderr, "Entry not found in database\n");
	break;
    case 0: {
	char buf[128];
	char *name;

	krb5_unparse_name(context, ent.principal, &name);
	printf("Principal: %s\n", name);
	free(name);
	puttime (*ent.max_life, buf, sizeof(buf));
	printf("Max ticket life: %s\n", buf);
	puttime (*ent.max_renew, buf, sizeof(buf));
	printf("Max renewable ticket life: %s\n", buf);
	if (ent.created_by.principal)
	    krb5_unparse_name (context, ent.created_by.principal, &name);
	else
	    name = NULL;
	printf("Created by %s at %s\n",
	       name ? name : "<unknown>",
	       time2str(ent.created_by.time));
	free (name);
	if (ent.modified_by) {
	    if (ent.modified_by->principal)
		krb5_unparse_name (context, ent.modified_by->principal, &name);
	    else
		name = NULL;
	    printf("Last modified by %s at %s\n",
		   name ? name : "<unknown>",
		   time2str(ent.modified_by->time));
	    free (name);
	}
	if (ent.valid_start) {
	    printf("Valid from %s\n", time2str(*ent.valid_start));
	}
	if (ent.valid_end) {
	    printf("Valid till %s\n", time2str(*ent.valid_end));
	}
	if (ent.pw_end) {
	    printf("Password expires at %s\n", time2str(*ent.pw_end));
	}
	printf("Kvno: %d\n", ent.kvno);
	printf("Keys: ");
	for(i = 0; i < ent.keys.len; i++){
	    if(i) printf(", ");
	    printf("type = %d, len = %d", ent.keys.val[i].key.keytype,
		   ent.keys.val[i].key.keyvalue.length);
	}
	printf("\n");
	{
	    int first_flag = 1;

	    printf("Flags: ");
#define PRINT_FLAG(f)				\
if(ent.flags. ##f) { 				\
    if(!first_flag)				\
	printf(", ");				\
    printf("%s", #f);				\
    first_flag = 0;				\
}
	    PRINT_FLAG(initial);
	    PRINT_FLAG(forwardable);
	    PRINT_FLAG(proxiable);
	    PRINT_FLAG(renewable);
	    PRINT_FLAG(postdate);
	    PRINT_FLAG(server);
	    PRINT_FLAG(client);
	    PRINT_FLAG(invalid);
	    PRINT_FLAG(require_preauth);
	    PRINT_FLAG(change_pw);
	    printf("\n");
	}
	break;
    }
    default:
	fprintf(stderr, "dbget: %s\n", krb5_get_err_text(context, ret));;
	break;
    }
    memset(&ent, 0, sizeof(ent));
    db->close(context, db);
    return 0;
}
