/*
 * Decompiled with CFR 0.152.
 */
package netscape.security;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import netscape.security.PrivilegeManager;
import netscape.security.UserDialogHelper;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public final class Principal
implements Codable {
    static final int VERSION = 1;
    public static final int CODEBASE_EXACT = 10;
    public static final int CODEBASE_REGEXP = 11;
    public static final int CERT = 12;
    public static final int CERT_FINGERPRINT = 13;
    public static final int CERT_KEY = 14;
    static final int COMPANY_NAME = 1;
    static final int CERT_AUTH = 2;
    static final int SERIAL_NO = 3;
    static final int EXP_DATE = 4;
    static final int NICKNAME = 5;
    static final int FINGERPRINT = 6;
    private int itsType;
    private int itsHashCode;
    private String itsStringRep;
    private byte[] itsBinaryRep;
    private byte[] itsFingerprint;
    private byte[] itsCertKey;
    private int itsZig;
    private boolean itsInited = false;
    private String itsNickname;
    private String itsAsciiFingerPrint;
    private String itsExpDate;
    private String itsSerialNo;
    private String itsCertAuth;
    private String itsCompanyName;

    public Principal() {
    }

    public Principal(URL uRL) {
        this.itsStringRep = uRL.toString();
        this.itsType = 10;
        this.computeHashCode();
        this.itsZig = 0;
        this.itsInited = true;
    }

    public Principal(int n, String string) {
        switch (n) {
            case 10: 
            case 11: {
                this.itsStringRep = string;
                break;
            }
            case 12: 
            case 13: {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ":;, \t");
                this.itsBinaryRep = new byte[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreElements()) {
                    this.itsBinaryRep[n2] = (byte)Integer.parseInt(stringTokenizer.nextToken(), 16);
                    ++n2;
                }
                if (n == 12) {
                    this.certToFingerprint();
                    break;
                }
                this.itsFingerprint = this.itsBinaryRep;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown principal type");
            }
        }
        this.itsType = n;
        this.computeHashCode();
        this.itsZig = 0;
        this.itsInited = true;
    }

    public Principal(int n, byte[] byArray) {
        switch (n) {
            case 12: 
            case 13: 
            case 14: {
                try {
                    this.itsBinaryRep = (byte[])byArray.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new IllegalArgumentException("bogus value");
                }
                if (n == 12) {
                    this.certToFingerprint();
                    break;
                }
                if (n == 14) {
                    this.itsCertKey = this.itsBinaryRep;
                    break;
                }
                this.itsFingerprint = this.itsBinaryRep;
                break;
            }
            case 10: 
            case 11: {
                this.itsStringRep = new String(byArray, 0);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown principal type");
            }
        }
        this.itsType = n;
        this.computeHashCode();
        this.itsZig = 0;
        this.itsInited = true;
    }

    public Principal(int n, byte[] byArray, Class clazz) {
        this(n, byArray);
        this.itsZig = Principal.getZigPtr(clazz);
    }

    private boolean compareByteArrays(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray2.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Principal)) {
            return false;
        }
        Principal principal = (Principal)object;
        switch (this.itsType) {
            case 14: {
                switch (principal.itsType) {
                    case 14: {
                        return this.compareByteArrays(this.itsCertKey, principal.itsCertKey);
                    }
                }
                return false;
            }
            case 12: 
            case 13: {
                switch (principal.itsType) {
                    case 12: 
                    case 13: {
                        return this.compareByteArrays(this.itsFingerprint, principal.itsFingerprint);
                    }
                }
                return false;
            }
            case 10: 
            case 11: {
                switch (principal.itsType) {
                    case 10: 
                    case 11: {
                        return this.itsStringRep.equals(principal.itsStringRep);
                    }
                }
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.itsHashCode;
    }

    private int computeHashCode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n = n * 37 + byArray[n2];
            ++n2;
        }
        return n;
    }

    private void computeHashCode() {
        switch (this.itsType) {
            case 14: {
                this.itsHashCode = this.computeHashCode(this.itsCertKey);
                return;
            }
            case 12: 
            case 13: {
                this.itsHashCode = this.computeHashCode(this.itsFingerprint);
                return;
            }
            case 10: 
            case 11: {
                this.itsHashCode = this.itsStringRep.hashCode();
                return;
            }
        }
    }

    public boolean isCodebase() {
        return this.itsType == 10 || this.itsType == 11;
    }

    public boolean isCodebaseExact() {
        return this.itsType == 10;
    }

    public boolean isCodebaseRegexp() {
        return this.itsType == 11;
    }

    boolean isSecurePrincipal() {
        URL uRL;
        if (this == PrivilegeManager.getUnknownPrincipal()) {
            System.out.println("Principal: Internal Error: Unknown principal");
            return false;
        }
        if (!this.isCodebase()) {
            return true;
        }
        try {
            uRL = new URL(this.itsStringRep);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        String string = uRL.getProtocol();
        if (string.equals("https") || string.equals("file")) {
            return true;
        }
        PrivilegeManager privilegeManager = PrivilegeManager.getPrivilegeManager();
        return string.equals("http") && !privilegeManager.getJavaSecurityEnabled();
    }

    public boolean isCert() {
        return this.itsType == 12;
    }

    public boolean isCertFingerprint() {
        return this.itsType == 13 || this.itsType == 14;
    }

    public String toString() {
        switch (this.itsType) {
            case 14: {
                return this.getNickname();
            }
            case 12: 
            case 13: {
                StringBuffer stringBuffer = new StringBuffer();
                int n = 0;
                while (n < this.itsBinaryRep.length) {
                    if (n > 0) {
                        stringBuffer.append(":");
                    }
                    stringBuffer.append(Integer.toHexString(0xFF & this.itsBinaryRep[n]));
                    ++n;
                }
                return stringBuffer.toString();
            }
            case 10: 
            case 11: {
                return this.itsStringRep;
            }
        }
        return this.itsStringRep;
    }

    public String toVerboseString() {
        String string = this.toString();
        switch (this.itsType) {
            case 12: {
                return "CERT: " + string;
            }
            case 13: {
                return "CERT_FINGERPRINT: " + string;
            }
            case 14: {
                return "CERT_FINGERPRINT: " + string + " " + this.getFingerPrint();
            }
            case 10: {
                return "CODEBASE_EXACT: " + string;
            }
            case 11: {
                return "CODEBASE_REGEXP: " + string;
            }
        }
        return "Bogus type (" + this.itsType + "): " + string;
    }

    private void certToFingerprint() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.itsBinaryRep.length) {
            n = n * 37 + this.itsBinaryRep[n2];
            ++n2;
        }
        String string = Integer.toString(n);
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length() - 1, byArray, 0);
        this.itsFingerprint = byArray;
    }

    public String getVendor() {
        switch (this.itsType) {
            case 12: 
            case 13: 
            case 14: {
                return this.getNickname();
            }
        }
        return this.itsStringRep;
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("Principal", 1);
        classInfo.addField("Type", (byte)8);
        classInfo.addField("HashCode", (byte)8);
        classInfo.addField("StringRep", (byte)16);
        classInfo.addField("BinaryRep", (byte)5);
        classInfo.addField("Fingerprint", (byte)5);
        classInfo.addField("CertKey", (byte)5);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt("Type", this.itsType);
        encoder.encodeInt("HashCode", this.itsHashCode);
        encoder.encodeString("StringRep", this.itsStringRep);
        if (this.itsType == 12 || this.itsType == 13 || this.itsType == 14) {
            encoder.encodeByteArray("BinaryRep", this.itsBinaryRep, 0, this.itsBinaryRep.length);
            encoder.encodeByteArray("Fingerprint", this.itsFingerprint, 0, this.itsFingerprint == null ? 0 : this.itsFingerprint.length);
            encoder.encodeByteArray("CertKey", this.itsCertKey, 0, this.itsCertKey == null ? 0 : this.itsCertKey.length);
        }
    }

    public void decode(Decoder decoder) throws CodingException {
        if (this.itsInited) {
            return;
        }
        this.itsInited = true;
        this.itsType = decoder.decodeInt("Type");
        this.itsHashCode = decoder.decodeInt("HashCode");
        this.itsStringRep = decoder.decodeString("StringRep");
        if (this.itsType == 12 || this.itsType == 13 || this.itsType == 14) {
            this.itsBinaryRep = decoder.decodeByteArray("BinaryRep");
            this.itsFingerprint = decoder.decodeByteArray("Fingerprint");
            this.itsCertKey = decoder.decodeByteArray("CertKey");
        }
    }

    public void finishDecoding() throws CodingException {
    }

    String getCompanyName() {
        if (this.itsCompanyName == null) {
            this.itsCompanyName = this.getCertAttribute(this.itsZig, 1, this.itsCertKey);
        }
        return this.itsCompanyName;
    }

    String getSecAuth() {
        if (this.itsCertAuth == null) {
            this.itsCertAuth = this.getCertAttribute(this.itsZig, 2, this.itsCertKey);
        }
        return this.itsCertAuth;
    }

    String getSerialNo() {
        if (this.itsSerialNo == null) {
            this.itsSerialNo = this.getCertAttribute(this.itsZig, 3, this.itsCertKey);
        }
        return this.itsSerialNo;
    }

    String getExpDate() {
        if (this.itsExpDate == null) {
            this.itsExpDate = this.getCertAttribute(this.itsZig, 4, this.itsCertKey);
        }
        return this.itsExpDate;
    }

    public String getFingerPrint() {
        switch (this.itsType) {
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return this.toString();
            }
        }
        if (this.itsAsciiFingerPrint == null) {
            this.itsAsciiFingerPrint = this.getCertAttribute(this.itsZig, 6, this.itsCertKey);
        }
        return this.itsAsciiFingerPrint;
    }

    public String getNickname() {
        if (this.itsType == 12 && this == PrivilegeManager.getUnsignedPrincipal()) {
            return UserDialogHelper.getUnsignedPrincipal();
        }
        if (this.itsNickname == null) {
            this.itsNickname = this.getCertAttribute(this.itsZig, 5, this.itsCertKey);
        }
        return this.itsNickname;
    }

    boolean savePrincipalPermanently() {
        if (this.isCodebase() || this.itsZig == 0) {
            return true;
        }
        return this.saveCert(this.itsZig, this.itsCertKey);
    }

    static Principal createPrincipal(String string) {
        byte[] byArray = Principal.getPrincipalCertKey(string);
        if (byArray != null) {
            return new Principal(14, byArray);
        }
        throw new IllegalArgumentException("Unknown principal " + string);
    }

    static Principal createSystemPrincipal() {
        Object[] objectArray = Principal.getSystemPrincipalCertKey();
        if (objectArray != null && objectArray.length > 0) {
            return new Principal(14, (byte[])objectArray[0]);
        }
        throw new IllegalArgumentException("Unknown system principal ");
    }

    static boolean isSystemPrincipal(byte[] byArray) {
        Principal principal = PrivilegeManager.getSystemPrincipal();
        if (principal.itsCertKey == null) {
            return false;
        }
        return principal.compareByteArrays(byArray, principal.itsCertKey);
    }

    public boolean isSystemPrincipal() {
        return this.equals(PrivilegeManager.getSystemPrincipal());
    }

    private static Principal[] getPrincipalAry(Class clazz, String string, Object[] objectArray) {
        Principal[] principalArray = null;
        int n = 0;
        if (objectArray != null) {
            n += objectArray.length;
        }
        if (n == 0) {
            return PrivilegeManager.getUnknownPrincipalArray();
        }
        principalArray = new Principal[n];
        int n2 = n;
        while (n2-- > 0) {
            principalArray[n2] = Principal.isSystemPrincipal((byte[])objectArray[n2]) ? PrivilegeManager.getSystemPrincipal() : new Principal(14, (byte[])objectArray[n2], clazz);
        }
        return principalArray;
    }

    private static native int getZigPtr(Class var0);

    native String getCertAttribute(int var1, int var2, byte[] var3);

    static native byte[] getPrincipalCertKey(String var0);

    static native Object[] getSystemPrincipalCertKey();

    private native boolean saveCert(int var1, byte[] var2);
}

