/*
 * Decompiled with CFR 0.152.
 */
package netscape.secfile;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import netscape.secfile.FileInputStreamNoFinalize;
import netscape.secfile.SecureFile;
import netscape.secfile.SecureFileException;
import netscape.secfile.SecureRandomAccessFile;
import netscape.security.Principal;
import netscape.security.PrivilegeManager;

public class SecureFileInputStream
extends FileInputStream {
    private String prepend;
    private Principal prin;

    public SecureFileInputStream(String string) throws FileNotFoundException {
        this(string, SecureFile.getClassPrincipal(1), 1);
    }

    public SecureFileInputStream(SecureFile secureFile) throws FileNotFoundException {
        this(secureFile.getPath(), secureFile.getPrincipal(), 1);
    }

    public SecureFileInputStream(FileDescriptor fileDescriptor) {
        this(fileDescriptor, PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdRead")));
        this.prin = null;
    }

    private static FileDescriptor rethrow(String string, String string2) throws FileNotFoundException {
        FileInputStreamNoFinalize fileInputStreamNoFinalize;
        PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFileRead"));
        try {
            fileInputStreamNoFinalize = new FileInputStreamNoFinalize(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException(string2);
        }
        try {
            return fileInputStreamNoFinalize.getFD();
        }
        catch (IOException iOException) {
            throw new SecureFileException("Internal error");
        }
    }

    public SecureFileInputStream(String string, Principal principal) throws FileNotFoundException {
        this(string, principal, 1);
    }

    SecureFileInputStream(String string, Principal principal, int n) throws FileNotFoundException {
        this(SecureFileInputStream.rethrow(SecureFile.getPrependedPath(SecureFile.getPrepend(principal, n + 1), string), string), PrivilegeManager.enableTarget(SecureRandomAccessFile.CheckLimitedFileAccess("UniversalFdRead")));
        this.prepend = SecureFile.getPrepend(principal, n + 1);
        SecureFile.checkCanonicalPath(string, this.prepend);
        this.prin = principal;
    }

    private SecureFileInputStream(FileDescriptor fileDescriptor, Object object) {
        super(fileDescriptor);
    }

    public Principal getPrincipal() {
        return this.prin;
    }
}

