;;; $Id: irchat-500.el,v 1.2 1994/08/01 11:28:29 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(eval-when-compile
  (require 'irchat-inlines))
;;;
;;;  500 replies -- ERRORS
;;;
(defun irchat-handle-500-msgs (number prefix rest)
  (if (string-match "[^ ]* \\([^ :]*\\) *\\([^ :]*\\) *:\\(.*\\)" rest)
      (let ((target1 (matching-substring rest 1))
	    (target2 (matching-substring rest 2))
	    (msg (matching-substring rest 3)))
	(cond ((string-equal target1 "")
	       (insert (format "*** Error: %s" msg)))
	      ((string-equal target2 "")
	       (insert (format "*** Error: %s (%s)" msg target1)))
	      (t
	       (insert (format "*** Error: %s %s (%s)" target1 msg target2))))
	(newline))
    (message "IRCHAT: Strange %s reply" number)))
;;;
;;; eof
;;;


