/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class CatchCmd
implements Command {
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length != 2 && argv.length != 3) {
            throw new TclNumArgsException(interp, 1, argv, "command ?varName?");
        }
        int code = 0;
        try {
            interp.eval(argv[1], 0);
        }
        catch (TclException e) {
            code = e.getCompletionCode();
        }
        TclObject result = interp.getResult();
        if (argv.length == 3) {
            try {
                interp.setVar(argv[2], result, 0);
            }
            catch (TclException e) {
                throw new TclException(interp, "couldn't save command result in variable");
            }
        }
        interp.setResult(TclInteger.newInstance((int)code));
    }

    CatchCmd() {
    }
}

