#!/usr/bin/perl

package eBay::API::XML::Call::GetUserPreferences;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetUserPreferences.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetUserPreferences

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetUserPreferences inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesRequestType;
use eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'GetUserPreferences';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::GetUserPreferences::GetUserPreferencesResponseType';
}

#
# input properties
#

=head2 setShowBidderNoticePreferences()

If true, requests a seller's preferences for receiving bidder notices.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowBidderNoticePreferences {
   my $self   = shift;
   my $sShowBidderNoticePreferences = shift;
   $self->getRequestDataType()->setShowBidderNoticePreferences($sShowBidderNoticePreferences);
}

=head2 setShowCombinedPaymentPreferences()

DO NOT USE THIS FIELD. Use 'GetShippingDiscountProfiles' to access
similar information.
If true, requests a seller's preferences for accepting payments
that combine item purchases into one order.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowCombinedPaymentPreferences {
   my $self   = shift;
   my $sShowCombinedPaymentPreferences = shift;
   $self->getRequestDataType()->setShowCombinedPaymentPreferences($sShowCombinedPaymentPreferences);
}

=head2 setShowCrossPromotionPreferences()

If true, requests a seller's cross-promotion preferences, such as
whether cross-promotions are enabled and the sort filters used.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowCrossPromotionPreferences {
   my $self   = shift;
   my $sShowCrossPromotionPreferences = shift;
   $self->getRequestDataType()->setShowCrossPromotionPreferences($sShowCrossPromotionPreferences);
}

=head2 setShowEmailShipmentTrackingNumberPreference()

If true, returns the preference related to emailing the email shipment tracking number.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowEmailShipmentTrackingNumberPreference {
   my $self   = shift;
   my $sShowEmailShipmentTrackingNumberPreference = shift;
   $self->getRequestDataType()->setShowEmailShipmentTrackingNumberPreference($sShowEmailShipmentTrackingNumberPreference);
}

=head2 setShowEndOfAuctionEmailPreferences()

If true, displays the seller's end of auction email preferences.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowEndOfAuctionEmailPreferences {
   my $self   = shift;
   my $sShowEndOfAuctionEmailPreferences = shift;
   $self->getRequestDataType()->setShowEndOfAuctionEmailPreferences($sShowEndOfAuctionEmailPreferences);
}

=head2 setShowProStoresPreferences()

If true, returns ProStores checkout preferences.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowProStoresPreferences {
   my $self   = shift;
   my $sShowProStoresPreferences = shift;
   $self->getRequestDataType()->setShowProStoresPreferences($sShowProStoresPreferences);
}

=head2 setShowSellerFavoriteItemPreferences()

If true, retrieves preferences the seller has set for displaying items
on a buyer's favorite sellers page and in the favorite sellers email digest.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowSellerFavoriteItemPreferences {
   my $self   = shift;
   my $sShowSellerFavoriteItemPreferences = shift;
   $self->getRequestDataType()->setShowSellerFavoriteItemPreferences($sShowSellerFavoriteItemPreferences);
}

=head2 setShowSellerPaymentPreferences()

If true, displays a seller's payment preferences, for displaying
a Pay Now button, accepting PayPal, and so on.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut
       
sub setShowSellerPaymentPreferences {
   my $self   = shift;
   my $sShowSellerPaymentPreferences = shift;
   $self->getRequestDataType()->setShowSellerPaymentPreferences($sShowSellerPaymentPreferences);
}



#
# output properties
#

=head2 getBidderNoticePreferences()

Contains a seller's preferences for receiving bidder notices.
Returned when the request sets ShowBidderNoticePreferences to true.

  Returned: Conditionally
#    Returns: 'ns:BidderNoticePreferencesType'

=cut
       
sub getBidderNoticePreferences {
   my $self = shift;
   return $self->getResponseDataType()->getBidderNoticePreferences();
}

=head2 getCombinedPaymentPreferences()

DO NOT USE THIS FIELD. Use 'GetShippingDiscountProfiles' to retrieve
similar information. 
Contains a seller's preferences for accepting combined payments.
Returned when ShowCombinedPaymentPreferences is true.

  Returned: Conditionally
#    Returns: 'ns:CombinedPaymentPreferencesType'

=cut
       
sub getCombinedPaymentPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getCombinedPaymentPreferences();
}

=head2 getCrossPromotionPreferences()

Contains a seller's cross-promotion preferences.
Returned when ShowCrossPromotionPreferences is true.

  Returned: Conditionally
#    Returns: 'ns:CrossPromotionPreferencesType'

=cut
       
sub getCrossPromotionPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getCrossPromotionPreferences();
}

=head2 isEmailShipmentTrackingNumberPreference()

Contains the user's preference for the email shipment tracking number.

  Returned: Conditionally
#    Returns: 'xs:boolean'

=cut
       
sub isEmailShipmentTrackingNumberPreference {
   my $self = shift;
   return $self->getResponseDataType()->isEmailShipmentTrackingNumberPreference();
}

=head2 getEndOfAuctionEmailPreferences()

Contains the user's end of auction email preferences.

  Returned: Conditionally
#    Returns: 'ns:EndOfAuctionEmailPreferencesType'

=cut
       
sub getEndOfAuctionEmailPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getEndOfAuctionEmailPreferences();
}

=head2 getProStoresPreference()

Details about ProStores and checkout preferences. Returned only if requested
on input.

  Returned: Conditionally
#    Returns: 'ns:ProStoresCheckoutPreferenceType'

=cut
       
sub getProStoresPreference {
   my $self = shift;
   return $self->getResponseDataType()->getProStoresPreference();
}

=head2 getSellerFavoriteItemPreferences()

Contains a seller's preferences for displaying items on a buyer's
Favorite Sellers' Items page or Favorite Sellers' Items digest.

  Returned: Conditionally
#    Returns: 'ns:SellerFavoriteItemPreferencesType'

=cut
       
sub getSellerFavoriteItemPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getSellerFavoriteItemPreferences();
}

=head2 getSellerPaymentPreferences()

Contains a seller's preferences for accepting payments.
Returned when ShowSellerPaymentPreferences is true.

  Returned: Conditionally
#    Returns: 'ns:SellerPaymentPreferencesType'

=cut
       
sub getSellerPaymentPreferences {
   my $self = shift;
   return $self->getResponseDataType()->getSellerPaymentPreferences();
}





1;   
