#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Label (term)


************************************************************
*                                                          *
*  Subroutine Plotting_Menu                                *
*                                                          *
*     This subroutine allows the user to enter labels      *
*     of maximum length 20 characters for the x and y      *
*     axis and 60 for the title.  The labels and title     *
*     are centered appropriately unless the user does      *
*     not desire this.  The user also has the chance to    *
*     change the curve names to something other than       *
*     "Curve 1", and the minimum and maximum labels of     *
*     the window may be changed (to letters, or whatever). *
*                                                          *
************************************************************


        Real           WXmax, WXmin, WYmax, WYmin
        Common /windw/ WXmax, WXmin, WYmax, WYmin
        Save   /windw/

        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/

        Character       xaxis*20, yaxis*20, title*60, ans
        Common /Labels/ xaxis, yaxis, title
        Save   /Labels/

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Character *10 num1, num2, num3, num4, temps
        Integer term
        Logical centrd
*
*     Find if automatic centering should be turned on.
*
   12   Call clear(term)
        Write (*,10)
        Write (*,15) 
   15   Format (/,5x,'Do you want labels to be automatically centered?',
     +          2x,'(default = yes)')
        Read (*,'(a1)',err=12) ans
        centrd = (ans .NE. 'n' .AND. ans .NE. 'N')
*
*       (* Display the xaxis, yaxis, and title labels, and allow
*          the user to change, if they so desire. *)
*       (* Xaxis *)
    1   Call clear(term)
        Write (*,10)
   10   Format(//,15x,'Select Labels')
        Write (*,20) xaxis
   20   Format (//,5x,' x-axis = (''',a20,''')',//5x,'Do you wish ',
     +          'to change (Y/N) ...') 
        Read (*,'(a1)',err=1) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
          Call clear(term)
          Write (*,30)
   30     Format (/,5x,'Please enter the desired x-axis label:'/,
     +            20x,' (max 20 characters)',/'v',18(' '),'v')
          Read (*,'(a20)',err=1) xaxis
          IF (centrd) THEN
            Call center (xaxis)
          ENDIF
        ENDIF

*       (* Yaxis *)
    2   Call clear(term)
        Write (*,10)
        Write (*,40) yaxis(1:10), yaxis(11:20)
   40   Format (//,5x,' y-axis1 = (''',a10,''')',/,5x,' y-axis2 = ',
     +          '(''',a10,''')',//5x,'Do you wish to change (Y/N) ...')
        Read (*,'(a1)',err=2) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
          Call clear(term)
          Write (*,50)
   50     Format (/,5x,'Please enter the desired y-axis1 label:'/,
     +            10x,' (max 10 characters)',/'v',8(' '),'v')
          Read (*,'(a10)',err=2) yaxis(1:10)
          IF (centrd) THEN
            Call center (yaxis(1:10))
          ENDIF
          Write (*,60)
   60     Format (/,5x,'Please enter the desired y-axis2 label:'/,
     +            10x,' (max 10 characters)',/'v',8(' '),'v')
          Read (*,'(a10)',err=2) yaxis(11:20)
          IF (centrd) THEN
            Call center (yaxis(11:20))
          ENDIF
        ENDIF

*       (* Title *)
    3   Call clear(term)
        Write (*,10)
        Write (*,70) title
   70   Format (//,5x,' title = (''',a60,''')',//5x,'Do you wish ',
     +          'to change (Y/N) ...') 
        Read (*,'(a1)',err=3) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
          Call clear(term)
          Write (*,80)
   80     Format (/,5x,'Please enter the desired plot title:'/,
     +            20x,' (max 60 characters)',/'v',58(' '),'v')
          Read (*,'(a60)',err=3) title
          IF (centrd) THEN
            Call center (title)
          ENDIF
        ENDIF
*
*       (* Curve Titles *)
*
  111   Call clear(term)
        Write (*,10)
        Write (*,120) crv(1), crv(2), crv(3)
  120   Format (//,5x,' Curve1 = (''',a7,''')',/,
     +             5x,' Curve2 = (''',a7,''')',/,
     +             5x,' Curve3 = (''',a7,''')',//5x,'Do you wish ',
     +          'to change (Y/N) ...') 
        Read (*,'(a1)',err=111) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
*         (* Curve1 *)
          Call clear(term)
          IF (centrd) THEN
            Write (*,128)
  128       Format (1x, 'NOTE:  Curve labels will NOT be'
     +              ,' automatically centered'/)
          ENDIF
          Write (*,130)
  130     Format (/,5x,'Please enter the desired Curve1 label:'/,
     +            20x,' (max 7 characters)',/'v',5(' '),'v')
          Read (*,'(a7)',err=111) crv(1)
*         (* Curve2 *)
          Write (*,230)
  230     Format (/,5x,'Please enter the desired Curve2 label:'/,
     +            20x,' (max 7 characters)',/'v',5(' '),'v')
          Read (*,'(a7)',err=111) crv(2)
*         (* Curve3 *)
          Write (*,330)
  330     Format (/,5x,'Please enter the desired Curve3 label:'/,
     +            20x,' (max 7 characters)',/'v',5(' '),'v')
          Read (*,'(a7)',err=111) crv(3)
        ENDIF
*
*       (* Window edge labels *)
*
        Call number (WXmin, .TRUE., num1)
        Call number (WXmax, .TRUE., num2)
        Call number (WYmin, .TRUE., num3)
        Call number (WYmax, .TRUE., num4)
  540   Call clear(term)
        Write (*,10)
        Write (*,559)
  559   Format (/,'NOTE:  Does NOT affect window size or ',
     +          'calibration.',/,'       Just sets LABELS',
     +          ' to any desired alpha-numeric string.')
        Write (*,550) num1, num2, lowx, hix, num3, num4, lowy, hiy
  550   Format (/,5x,'Current window settings:',//
     +          ,12x,'X-min',10x,'X-max',/,10x,10('-'),5x,10('-')/
     +          ,10x,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>'//
     +          ,12x,'Y-min',10x,'Y-max',/,10x,10('-'),5x,10('-'),/10x
     +          ,a10,5x,a10,/,9x,'<',a10,'>',3x,'<',a10,'>',/5x,/
     +          'Do you wish to change (Y/N) ...')
        Read (*,'(a1)',err=540) ans

        IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
          Call clear(term)
          Write (*,560)
  560     Format (//,'Please enter Y axis maximum label.',/,
     +            'v        v')
          Read (*,'(a10)',err=540) hiy
*
*        (* Right justify string *)
*
          IF (hiy .NE. ' ') THEN
            j = 10
  565       IF (hiy(j:j) .EQ. ' ') THEN
              j = j - 1
              GOTO 565
            ENDIF
            temps = hiy(:j)
            hiy = ' '
            hiy(11-j:) = temps
          ENDIF
*
          Call clear(term)
          Write (*,570)
  570     Format (//,'Please enter Y axis minimum label.',/,
     +            'v        v')
          Read (*,'(a10)',err=540) lowy
*
*        (* Right justify string *)
*
          IF (lowy .NE. ' ') THEN
            j = 10
  575       IF (lowy(j:j) .EQ. ' ') THEN
              j = j - 1
              GOTO 575
            ENDIF
            temps = lowy(:j)
            lowy = ' '
            lowy(11-j:) = temps
          ENDIF
*
          Call clear(term)
          Write (*,580)
  580     Format (//,'Please enter X axis maximum label.',/,
     +            'v        v')
          Read (*,'(a10)',err=540) hix
*
*        (* Right justify string *)
*
          IF (hix .NE. ' ') THEN
            j = 10
  585       IF (hix(j:j) .EQ. ' ') THEN
              j = j - 1
              GOTO 585
            ENDIF
            temps = hix(:j)
            hix = ' '
            hix(11-j:) = temps
          ENDIF
*
          Call clear(term)
          Write (*,590)
  590     Format (//,'Please enter X axis minimum label.',/,
     +            'v        v')
          Read (*,'(a10)',err=540) lowx
*
*        (* Left justify string *)
*
          IF (lowx .NE. ' ') THEN
            j = 1
  595       IF (lowx(j:j) .EQ. ' ') THEN
              j = j + 1
              GOTO 595
            ENDIF
            temps = lowx(j:)
            lowx = ' '
            lowx = temps
          ENDIF
*
        ENDIF
        RETURN
        END

