#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C

        Subroutine Color (term, NumCrv)


********************************************************
*                                                      *
*   Subroutine Set_Plot_Color                          *
*                                                      *
*      This subroutine allows the user to specify      *
*      the color desired for the plot.  The choice     *
*      of colors are red, green, blue, yellow, cyan,   *
*      magenta, and white.  The color option exists    *
*      only when using the VT240 and the gigi type     *
*      terminals.                                      *
*                                                      *
********************************************************


        Integer    gigi, vt240R, ibmPC
        Parameter  (gigi = 1, vt240R = 2, ibmPC = 6)
        Character ans

        Integer        CColor(3), Backgd
        Common /CDefs/ CColor, Backgd
        Save   /CDefs/

        Integer   term, NumCrv, I


*       (* Make sure that the graphic device supports color. *)
        IF ((term .EQ. gigi) .OR. (term .EQ. vt240R) .OR.
     +      (term .EQ. ibmPC)) THEN

          DO 100 I = 1, NumCrv
    1       Call clear(term)
            Write (*,10)
   10       Format(/,15x,'Select Color',///
     +              , 5x,'The following colors are available:',//
     +              ,10x,'0.  Dark      ',19x,'4.  Green     ',//
     +              ,10x,'1.  Blue      ',19x,'5.  Cyan      ',//
     +              ,10x,'2.  Red       ',19x,'6.  Yellow    ',//
     +              ,10x,'3.  Magenta   ',19x,'7.  White     ',/)
            Write (*,20) I
   20       Format(5x,'Enter color (0 - 7) for curve ',i1,'...')
            Read(*,'(i2)',err=1) CColor(I)

*           (* Check to see if a valid color was entered. *)
  200       IF (CColor(I) .LT. 0 .OR. CColor(I) .GT. 7) THEN
    2         Call clear(term)
              Write (*,'(a1)') Char(7)
              Write (*,10)
              Write (*,20) I
              Read(*,'(i2)',err=2) CColor(I)
              GOTO 200
            ENDIF
  100     CONTINUE

    3     Call clear(term)
          Write (*,30)
   30     Format(/,15x,'Select Colors',//,5x,'Do you wish',
     +           ' to change the background? (Y/N)...')
          Read(*,'(a1)',err=3) ans

          IF (ans .EQ. 'y' .OR. ans .EQ. 'Y') THEN
*           (* Read the BackGround Color. *)
    4       Call clear(term)
            Write (*,10)
            Write (*,40)
   40       Format(/,15x,'Select Colors',//,5x,'Enter color ',
     +             '(0-7) for background...')
            Read(*,'(i1)',err=4) Backgd

*           (* Check to see if a valid color was selected. *)
  300       IF (Backgd .LT. 0 .OR. Backgd .GT. 7) THEN
    5         Call clear(term)
              Write (*,10)
              Write (*,30)
              Read(*,'(i1)',err=5) Backgd
              GOTO 300
            ENDIF
          ENDIF

        ELSE
    6     Call clear(term)
          Write (*,50)
   50     Format(/,15x,'Select Colors',//,5x,
     +           'Color is not available with this terminal setting.'
     +           ,//,5x,'Press <return> to continue ...')
          Read(*,'(a1)',err=6) 
        ENDIF

        RETURN
        END
