/*
 *+-------------------------------------------------------------------------+
 *| "triangle.h" - Header file for data structure and constants.            |
 *|                                                                         |
 *| Author: Michael S. A. Robb         Version: 1.4          Date: 30/05/93 |
 *+-------------------------------------------------------------------------+
 */

#define FIXED_POINT  16  /* Number of bits in the fraction */

/*
 *+-------------------------------------------------------------------------+
 *| The following data structure is used to represent the coordinate of a   |
 *| polygon vertex.                                                         |
 *+-------------------------------------------------------------------------+
 */

typedef struct coord_st
  {
  long c_xpos;    /* X coordinate.       */
  long c_ypos;    /* Y coordinate.       */
  long c_zpos;    /* Z coordinate.       */
  long c_red;     /* Amount of red.      */
  long c_green;   /* Amount of green.    */
  long c_blue;    /* Amount of blue.     */
  long c_blend;   /* Amount of blending. */
  } COORD;

/*
 *+-------------------------------------------------------------------------+
 *| The following data structure is used to represent a single edge of the  |
 *| triangle.                                                               |
 *+-------------------------------------------------------------------------+
 */

typedef struct edge_st
  {
  long e_xpos;    /* Current X     coordinate */
  long e_ypos;    /* Current Y     coordinate */
  long e_zpos;    /* Current Z     coordinate */
  long e_red;     /* Current RED   component  */
  long e_green;   /* Current GREEN component  */
  long e_blue;    /* Current BLUE  component  */
  long e_blend;   /* Current BLEND component  */

  long e_dxpos;   /* Incremental X coordinate */
  long e_deltay;  /* Incremental Y coordinate */
  long e_dzpos;   /* Incremental Z coordinate */
  long e_dred;    /* Incremental RED   value  */
  long e_dgreen;  /* Incremental GREEN value  */
  long e_dblue;   /* Incremental BLUE  value  */
  long e_dblend;  /* Incremental BLEND value  */
  } EDGE;

/*
 *+-----------------------------------------------------------------------+
 *| Function prototypes.                                                  |
 *+-----------------------------------------------------------------------+
 */

void render_horizontal_line( void );

void edge_update( EDGE *edge );
void edge_init(   EDGE *edge, COORD  *v1, COORD *v2 );
void render_half( EDGE *e1,   EDGE *e2, long deltay, long ypos );

void render_triangle( COORD *tlist );
