/*+-----------------------------------------------------------------------+
 *| This header file defines the data structure used to represent a       |
 *| TMS34010 graphics mode.                                               |
 *|                                                                       |
 *| Author: Michael S. A. Robb         Version: 1.1        Date: 29/05/93 |
 *+-----------------------------------------------------------------------+
 */

/*+-----------------------------------------------------------------------+
 *| The following data structure is used to store the register settings   |
 *| which define the state of a TMS34010 graphics mode.                   |
 *+-----------------------------------------------------------------------+
 */

typedef struct tms34010_mode_st
  {
  char  tms_name[32];    /* Generic name for the video mode.         */

  WORD  tms_hesync;      /* Left-hand  edge of left border.          */
  WORD  tms_heblnk;      /* Left-hand  edge of active display.       */
  WORD  tms_hsblnk;      /* Right-hand edge of active display.       */
  WORD  tms_htotal;      /* Right-hand edge of right border.         */

  WORD  tms_vesync;      /* Top        edge of top border.           */
  WORD  tms_veblnk;      /* Top        edge of active display.       */
  WORD  tms_vsblnk;      /* Bottom     edge of active display.       */
  WORD  tms_vtotal;      /* Bottom     edge of bottom border.        */

  WORD  tms_dpyctl;      /* Used to control video timing.            */
  WORD  tms_dpystrt;     /* Address of the first pixel displayed.    */
  WORD  tms_dpytap;      /* Horizontal panning offset.               */

  WORD  tms_clockbase;   /* Clock frequency for horizontal timing.   */
  WORD  tms_pixelsize;   /* Size of pixels.                          */
  WORD  tms_videotiming; /* Interlaced mode / sync signals.          */
  WORD  tms_ramdac;      /* Used to select pixel size/overlay mode.  */

  WORD  tms_xmax;        /* No. of pixels in horizontal axis.        */
  WORD  tms_ymax;        /* No. of pixels in vertical   axis.        */
  WORD  tms_psize;       /* No. of bits per pixel.                   */
  WORD  tms_dpitch;      /* Display pitch of each scan line in bits. */
  } TMS34010_MODE;

/*+-----------------------------------------------------------------------+
 *| The following data structures define the various screen modes.        |
 *+-----------------------------------------------------------------------+
 */

extern WORD   colourxmax;
extern WORD   colourymax;

extern WORD   screen_width;
extern WORD   screen_height;

extern TMS34010_MODE mode512x512x32bit;
extern TMS34010_MODE mode512x256x32bit;
extern TMS34010_MODE mode512x480x32bit;


