#include "Monitor.hpp"

#include "Timer.hpp"

namespace swShader
{
	Monitor::Monitor(float update)
	{
		frameRate = 0;
		frameCount = 0;
		startTime = Timer::seconds();
		this->update = update;
	}

	Monitor::~Monitor()
	{
	}

	float Monitor::getFrameRate()
	{
		return frameRate;
	}

	void Monitor::setUpdateInterval(float update)
	{
		this->update = update;
	}

	float Monitor::getUpdateInterval()
	{
		return update;
	}

	float Monitor::newFrame()
	{
		frameCount++;

		double currentTime = Timer::seconds();
		double elapsedTime = currentTime - startTime;

		if(elapsedTime >= update)
		{
			frameRate = (float)frameCount / (float)elapsedTime;

			frameCount = 0;
			startTime = currentTime;
		}

		return frameRate;
	}
}