/* svdisplay.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* These procedures implement the routines necessary to handle Sunview window
  control routines for the Scry server.  These routines written by Antony
  A. Courtney, 5/11/89 and David Robertson 90 */

#include <stdio.h>
#include <math.h>
#include "svwin.h"
#include <scry_serv.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>


/* image_init:  creates server display window, canvas, and image memory
   init_image_vars:  initializes server display information
   svserv_repaint:  repaint procedure
   display_frame:  optionally decompresses, and displays incoming image */

Frame svserv_control ;	/* control panel */
Frame image_win ;	/* image display window */
Canvas image_canvas ;
Pixwin *canvas_svid ;
Pixrect *image_win_image ;

int S_maxcol ;		/* client should set ? */
int S_mapnum ;			/* number of entries in color map */
unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* color map */

struct image_stuff S_image_info ;	/* control and/or image information */

unsigned char *S_image_mem = NULL ;

float scry_gamma = S_DEF_GAMMA_VALUE ;	/* gamma value */

unsigned char red[S_MAX_COL_SIZE],green[S_MAX_COL_SIZE],blue[S_MAX_COL_SIZE] ;

int prev_colors = 0 ;	/* number of color map entries in previous frame */




/* creates server display window, canvas, and image memory */

image_init(argc,argv,winx,winy)

int argc ;
char *argv[] ;
int winx ;
int winy ;

{
    int i ;
    int n ;
    void svserv_repaint() ;	/* repaint procedure */

        /* initialize server display information */
    init_image_vars() ;

	/* creates the window to display the image in */
    svserv_control = window_create(NULL, FRAME,
                          FRAME_LABEL, "svserv control",
			  FRAME_EMBOLDEN_LABEL, TRUE,
			  FRAME_SHOW_LABEL, TRUE,
                          WIN_X, winx,
                          WIN_Y, winy,
                          WIN_WIDTH, 260,
                          WIN_HEIGHT, 46,
                          WIN_SHOW, TRUE,
                          NULL);

    a_panel.panel = window_create(svserv_control, PANEL,
                                  PANEL_LABEL_BOLD, TRUE,
                                  NULL);

    create_panel_items();

	/* creates the window to display the image in */
    image_win = window_create(svserv_control, FRAME,
                          FRAME_LABEL, "svserv image",
			  FRAME_EMBOLDEN_LABEL, TRUE,
			  FRAME_SHOW_SHADOW, FALSE,
			  FRAME_SHOW_LABEL, TRUE,
			  WIN_X, 10,
			  WIN_Y, 140,
                          WIN_WIDTH, S_image_info.s_width+10,
                          WIN_HEIGHT, S_image_info.s_height+23,
                          WIN_SHOW, TRUE,
                          NULL);

    image_canvas = window_create(image_win, CANVAS,
                           CANVAS_AUTO_SHRINK, TRUE,
                           CANVAS_AUTO_EXPAND, TRUE,
			   CANVAS_RETAINED, FALSE,
			   CANVAS_REPAINT_PROC, svserv_repaint,
                           0);

    canvas_svid = canvas_pixwin (image_canvas);
    image_win_image = mem_create (S_image_info.s_width, S_image_info.s_height, 8);
    S_image_mem = (unsigned char *) mpr_d(image_win_image)->md_image;
}




/* initializes server display information */

init_image_vars()


{
    S_image_info.s_height = S_DEF_WINSERV_HEIGHT ;
    S_image_info.s_width = S_DEF_WINSERV_WIDTH ;
    S_image_info.s_max_height = S_MAX_WINSERV_HEIGHT ;
    S_image_info.s_max_width = S_MAX_WINSERV_WIDTH ;
    S_image_info.s_recordable = 0 ;
	/* only 8-bit supported:  depth is in bytes */
    S_image_info.s_depth = 1;

    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
}




/* repaint procedure */

void
svserv_repaint(canvas,pixwin,repaint_area)

Canvas canvas;
Pixwin *pixwin ;
Rectlist *repaint_area ;

{
  if (!S_dont_repaint) ;
    pw_rop(canvas_svid, 0, 0, S_image_info.s_width, S_image_info.s_height, PIX_SRC,
	   image_win_image, 0, 0) ;
}




/* optionally decompresses, and displays incoming image */

display_frame (transp)

register SVCXPRT *transp ;	/* RPC transport handle */

{
    unsigned char *part ;	/* position in compressed image */
    int save_total ;
    int repaint_status ;
    int i, j ;
    int numpixels = S_image_info.s_depth * S_image_info.s_height ;
    int colors ;	/* number of colors */
    int scry_xform_indices[S_MAX_COL_SIZE] ;	/* noop: for compatibility with X
					   server */
    char sc_segname[80] ;

    panel_set_value(a_panel.gamma, "") ;
	/* write info (frame no. and offset) to the header table array */
	/* to be used by Anima */
    if (S_anima_file != NULL)
        S_a_index[S_anima_count].offset = S_anima_bytes;

	/* get control information */
    if (!svc_getargs(transp,xdr_image_info,&S_image_info))
    {
        svcerr_decode(transp) ;
        return(0) ;
    }
    if ((S_image_info.s_width > S_MAX_WINSERV_WIDTH) ||
        (S_image_info.s_height > S_MAX_WINSERV_HEIGHT) ||
        (S_image_info.s_width < 1) || (S_image_info.s_height < 1))
	   {
	       fprintf (stderr,"illegal sized image\n") ;
	       exit(0) ;
	   }
	/* if image different size than previous
	   image received */
    if ((S_image_info.c_width != S_image_info.s_width) ||
	(S_image_info.c_height != S_image_info.s_height))
    {
	repaint_status = S_dont_repaint ;
	S_dont_repaint = 1 ;
	S_image_info.s_width = S_image_info.c_width ;
	S_image_info.s_height = S_image_info.c_height ;
	    /* redo window and image */
        (void) window_set(image_win,
		WIN_WIDTH, S_image_info.s_width+10,
		WIN_HEIGHT, S_image_info.s_height+23,
		NULL) ;
	free(S_image_mem) ;
	free(image_win_image) ;
	free(S_image_info.data) ;
	image_win_image = mem_create(S_image_info.s_width, S_image_info.s_height, 8) ;
	S_image_mem = (unsigned char *) mpr_d(image_win_image)->md_image ;
	S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
	S_dont_repaint = repaint_status ;
    }
    if (S_anima_file != NULL)
    {
        S_a_index[S_anima_count].buf_total = S_image_info.total ;
        S_anima_count ++;
    }
	    /* get color map */
        if (!svc_getargs(transp,xdr_map,S_map))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }

	if ((S_anima_file != NULL) && !(S_image_info.compression & S_QUANTIZE))
            iff_write_header (S_anima_file,&S_image_info,S_image_info.s_height,
			      S_image_info.s_width, "many map Anima file") ;
               
	/* if Lempel-Ziv compression was used */
    if (S_image_info.compression & S_LEMPEL_ZIV)
    {
        save_total = S_image_info.total ;
	S_image_info.total = S_image_info.total_lz ;
	    /* get compressed info */
        if (!svc_getargs(transp,xdr_compressed,&S_image_info))
        {
	    svcerr_decode(transp) ;
	    return (0) ;
        }
	/* send acknowledgement - allows client to continue while
           decompression and display taking place. */
        if (svc_sendreply (transp,xdr_void,0) == 0)
        {
             fprintf (stderr,"err: rcp_service\n") ;
             return(0) ;
        }
	    /* decompress */
        lzw_decomp (S_image_info.data, &S_image_info.total) ;
        S_image_info.total = save_total ;
    }
    else
    {
            /* if Lempel-Ziv compression was not used on client */
        if (!svc_getargs(transp,xdr_compressed,&S_image_info))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }
	    /* send acknowledgement - allow client to continue */
        if (svc_sendreply (transp,xdr_void,0) == 0)
        {
            fprintf (stderr,"err: rcp_service\n") ;
            return(0) ;
        }
    }
	/* write out IFF header if client enabled writing to Anima file */
	/* CCC is only legal compression option */
    if ((S_anima_file != NULL) && !(S_image_info.compression & S_QUANTIZE))
        iff_write_buf(S_anima_file,&S_image_info) ;
	    /* if writing enabled and all frames have been received,
	       write Anima footer */
    if ((S_anima_file != NULL) && (S_image_info.total_frames == (S_image_info.current_frame_to_save + 1)))
    {
#ifdef MESSAGES
        fprintf (stderr,"writing Anima footer\n") ;
#endif
        anima_write_footer (S_anima_file) ;
        fclose(S_anima_file) ;
        anima_init() ;
    }

    memset((char *)red, 0, S_MAX_COL_SIZE*sizeof(char));
    memset((char *)green, 0, S_MAX_COL_SIZE*sizeof(char));
    memset((char *)blue, 0, S_MAX_COL_SIZE*sizeof(char)) ;

    if (S_mapnum > S_MAX_COL_SIZE)
    {
        fprintf (stderr,"illegal number of color map entries sent\n") ;
        fprintf (stderr,"exiting\n") ; 
        return(0) ;
    }
        /* load the colormap */
    for (i=0; i<S_mapnum;i++)
    {
        red[i] = S_map[i][S_RED];
        green[i] = S_map[i][S_GREEN];
        blue[i] = S_map[i][S_BLUE];
    }
    if (S_mapnum < 255)
    {
        red[255] = green[255] = blue[255] = 0 ;
        red[254] = green[254] = blue[254] = 0xFF;
    }
	/* don't use all 256 colors unless absolutely necessary */
    if(S_mapnum <= 128)
        colors = 128;
    else 
        colors = S_MAX_COL_SIZE;

    if (colors != prev_colors)
        sprintf(sc_segname, "%d %d\n", S_avars.pid, colors);
    pw_setcmsname(canvas_svid, sc_segname); /* assign segment name */
    prev_colors = colors ;

       /* perform gamma correction */
    for (i = 0; i < S_mapnum; i++) {
	if (scry_gamma != 1.0)
	{
	    red[i] = (int) (256. * pow((double) red[i] / 256., 1.0 / scry_gamma));
	    if (red[i] > 255)
	        red[i] = 255;
	    green[i] = (int) (256. * pow((double) green[i] / 256., 1.0 / scry_gamma));
	    if (green[i] > 255)
	        green[i] = 255;
	    blue[i] = (int) (256. * pow((double) blue[i] / 256., 1.0 / scry_gamma));
	    if (blue[i] > 255)
	        blue[i] = 255;
	}
    }

        /* for compatibility with X version */
    for (i = 0 ; i < 256 ; i++)
	scry_xform_indices[i] = i ;
	    /* CCC decompression */
    if (S_image_info.compression & S_CCC)
    {
        decompress_ccc (S_image_info.data,S_image_mem,S_image_info.s_height,S_image_info.s_width,scry_xform_indices);
    }
    else	 /* get 8-bit image */
    {
        for (i = 0 ; i < S_image_info.s_height ; i++)
        {
                bcopy (&(S_image_info.data[i*S_image_info.s_width]),
                   &(S_image_mem[i * S_image_info.s_width]), S_image_info.s_width) ;
        }
    }

    pw_putcolormap(canvas_svid, 0, colors, red, green, blue);
       /* display image */
    pw_rop(canvas_svid, 0, 0, S_image_info.s_width, S_image_info.s_height, PIX_SRC, image_win_image, 0, 0) ;
    S_dont_repaint = 0 ;

    return (1) ;
}
