/* redoccc.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include 	 <stdio.h> 


#define		SIZBLOC		4 	/* pixels per side of block */
#define		DEPTH		3	/* color resolution */



/* truncate image to size of server display */

unsigned char *
shrink_ccc (compdata,height,width,new_ht,new_wd,total)

unsigned char *compdata ;	/* compressed image */
int height ;			/* image height */
int width; 			/* image width */
int new_ht ;			/* server height */
int new_wd ;			/* server width */
int *total ;			/* total bytes in new compressed image */

{
    unsigned char *shrunk_data = NULL ;	/* compressed truncated image */
    int	position_in_row = 0 ;
    int row = -SIZBLOC ;
    int center_x_left, center_x_right ;	/* centering information */
    int center_y_bottom, center_y_top ;
    register unsigned char pix0, pix1 ;	/* the 2 colors inside a 4x4 block  */
    register unsigned char *ptin ;	/* pointer stepping through old image */
    register unsigned char *ptout ;	/* pointer stepping through new image */
    register int i, j ;
    unsigned short run_ctr ;
    int totblocks ;			/* total number of 4x4 blocks */
    int block_width_num ;		/* number of 4x4 blocks in row */
	/* used in truncating image */
    int right_trim, left_trim ;
    int right_pt, tmp_ctr ;

        /* allocate space for truncated image */
    shrunk_data = (unsigned char *) malloc(new_ht*new_wd/4) ;
    *total = 0 ;
    totblocks = (height * width) / ( SIZBLOC * SIZBLOC ) ;
    block_width_num = width / SIZBLOC ;
	/* new image will be taken from center of old */
    if (new_wd < width)
    {
        center_x_left = (width - new_wd) / 2 ;
        center_x_left -= (center_x_left % 4) ;
        center_x_right = center_x_left + new_wd ;
    }
    else
    {
	center_x_left = 0 ;
	center_x_right = width - (width % 4) ;
    }
    if (new_ht < height)
    {
        center_y_bottom = (height - new_ht) / 2 ;
        center_y_bottom -= (center_y_bottom % 4) ;
        center_y_top = center_y_bottom + new_ht ;
    }
    else
    {
	center_y_bottom = 0 ;
	center_y_top = height - (height % 4) ;
    }
    ptin = compdata ;
    ptout = shrunk_data ;
	/* for all blocks */
    for (i=0 ; i< totblocks ; i += run_ctr)
    {
	    /* if at beginning of row */
	if ((i % block_width_num) == 0)
	{
	    position_in_row = 0 ;
	    row += 4 ;
	}
	pix0 = *ptin++ ;
	pix1 = *ptin++ ;
        if ( pix1 != pix0 )       /* if 2 colors different */
        { 
		/* if not truncated */
	    if ((position_in_row >= center_x_left) &&
	        (position_in_row < center_x_right) &&
	        (row >= center_y_bottom) &&
	        (row < center_y_top))
	    {
		*ptout++ = pix0 ;
		*ptout++ = pix1 ;
	        *ptout++ = *ptin++ ;
	        *ptout++ = *ptin++ ;
		*total += 4 ;
	    }
	    else    /* truncate */
		ptin += 2 ;
	    position_in_row += 4 ;
	    run_ctr = 1 ;
	}
	else			/* is a run */
	{
	    run_ctr = *ptin++ ;
	    run_ctr = (run_ctr << 8) | *ptin++ ;
	    right_trim = left_trim = 0 ;
		/* if not truncated at bottom or top */
	    if ((row >= center_y_bottom) &&
		(row < center_y_top))
	    {
		    /* adjust run ctr to truncate */
		right_pt = position_in_row + run_ctr * 4 ;
		if (right_pt >= center_x_right)
                   right_trim = right_pt - center_x_right ;
		if (position_in_row < center_x_left)
		   left_trim = center_x_left - position_in_row ;
		tmp_ctr = run_ctr - (right_trim + left_trim)/4 ;
		if (tmp_ctr > 0)
		{
			*ptout++ = pix0 ;
			*ptout++ = pix0 ;
		        *ptout++ = (unsigned char) ((tmp_ctr >> 8) & 0xff) ;
		        *ptout++ = (unsigned char) (tmp_ctr & 0xff) ;
			*total += 4 ;
		}
	    }
	    position_in_row += run_ctr * 4 ;
        }
    }
    free(compdata) ;
    return (shrunk_data) ;
}
