/* start.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* part of server RPC library for both metafile and software frame
   buffer approaches */

#include <stdio.h>
#include "scrysrv.h"
#include "image.h"
#include <signal.h>


/* main:  parse command-line arguments and start appropriate service
   parse_args:  get command-line arguments
   tcp_service:  TCP server
   break_handler:  interrupt handling routine */


FILE *com1 ;		/* for writing to VTR   */

long record_on = 0 ;	/* recording is enabled by -r option */
long s_optflag = 0 ;	/* optical disk or not */

#ifdef EXCELAN
int break_enabled ;	/* signal enabled */
int abort_op ;		/* abort operation */
#endif



main (argc,argv)

int argc ;
char *argv[] ;
{
	/* parse command-line arguments */
    parse_args (argv,argc) ;
#ifdef EXCELAN
    if (!loaded())
    {
	fprintf (stderr,"Excelan driver not loaded\n") ;
	exit (0) ;
    }
    break_enabled = 1 ;
#endif
    
	/* server */
    tcp_service();

#ifdef EXCELAN
	/* should never get here */
    soclose(0);
#endif
}




/* parse command-line arguments */

parse_args (argv,argc)

char *argv[] ;
int argc ;

{
    int i ;

    for(i = 1; i < argc; i++)
    {
        if (*argv[i] != '-')
        {
            fprintf (stderr,"bad command line:  use %s -h for help\n",argv[0]) ;
            exit (-1) ;
        }
    	switch(*(argv[i]+1))
        {
            case 'r':
            case 'R':
		    /* recording enabled */
                record_on = 1 ;
                break ;
            case 'b':
		    /* border color */
                back_red = (unsigned char) atoi(argv[++i]) ;
                back_green = (unsigned char) atoi(argv[++i]) ;
                back_blue = (unsigned char) atoi(argv[++i]) ;
                break ; 
            case 'h':
            case 'H':
                fprintf (stderr,"usage is serv {-r -b r g b}\n") ;
                fprintf (stderr,"-r sets record option\n") ;
		fprintf (stderr,"-b sets border color:  r g and b\n") ;
		fprintf (stderr,"   should be between 0 and 255\n") ;
                fprintf (stderr,"-h displays this message\n") ;
                exit (1) ;
            default:
                fprintf (stderr,"use serv -h for help\n") ;
                exit(1);
        }
    }
}




/* TCP server */

tcp_service ()

{
    register SVCXPRT *transp ;	/* RPC transport handle */
#ifdef EXCELAN
    bool_t svc_getreq() ;
#endif
    int ret ;
    void break_handler();
 
        /* if recording enabled, initialize videodisk */
    if (record_on)
	if (!init_video(&s_optflag))
	    exit(0) ;

        /* initialize frame buffer */
    if (!init_display())
        exit(0) ;

	/* set routine to branch to on interrupt */
    ret = (int) signal(SIGINT, break_handler); 

#ifdef EXCELAN
    while (1)
    {
#endif
	    /* create transport handle (destroyed at bottom of loop) */
        if ((transp = svctcp_create(RPC_ANYSOCK,0,0)) == NULL)
        {
            fprintf (stderr,"svctcp_create: error\n") ;
            exit(1) ;
        }
	    /* register service (routine contain remote "procedures") */
        if (!svc_register(transp,PROGNUM,TESTVERS,graphics_dispatch,0))
        {
            fprintf (stderr, "PROGNUM svc_register: error\n") ;
            exit (1) ;
        }
	    /* serve RPC requests until client program exits */
#ifdef EXCELAN
        while (1)
           if (!svc_getreq(1))
               break ;
    }
#else
    svc_run();
#endif
    fprintf (stderr,"TCP loop should never exit\n") ;
}




/* Close all sockets (overkill, only one socket open) if interrupt
   detected.  PC hangs if ends with socket(s) open */

void
break_handler ()
{
    int i ;

    printf ("break_handler called\n") ;
#ifdef EXCELAN
    abort_op = 1 ;
    for (i=0 ; i < MAXSOCKET ; i++)
        soclose(i) ;
#endif
    exit(0);
}
